/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gui.IContainerSocketed;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.ItemTooltipUtil;
import forestry.core.utils.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SocketWidget
extends Widget {
    private final ISocketable tile;
    private final int slot;
    private final ToolTip toolTip = new ToolTip(250){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void refresh() {
            SocketWidget.this.toolTip.clear();
            ItemStack stack = SocketWidget.this.tile.getSocket(SocketWidget.this.slot);
            if (!stack.func_190926_b()) {
                SocketWidget.this.toolTip.add(ItemTooltipUtil.getInformation(stack));
                SocketWidget.this.toolTip.add(TextFormatting.ITALIC + Translator.translateToLocal("for.gui.socket.remove"));
            } else {
                SocketWidget.this.toolTip.add(Translator.translateToLocal("for.gui.emptysocket"));
            }
        }
    };

    public SocketWidget(WidgetManager manager, int xPos, int yPos, ISocketable tile, int slot) {
        super(manager, xPos, yPos);
        this.tile = tile;
        this.slot = slot;
    }

    @Override
    public void draw(int startX, int startY) {
        ItemStack socketStack = this.tile.getSocket(this.slot);
        if (!socketStack.func_190926_b()) {
            Minecraft.func_71410_x().func_175599_af().func_175042_a(socketStack, startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return this.toolTip;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        ItemStack itemstack = this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (itemstack.func_190926_b()) {
            return;
        }
        Item held = itemstack.func_77973_b();
        Container container = this.manager.gui.field_147002_h;
        if (!(container instanceof IContainerSocketed)) {
            return;
        }
        IContainerSocketed containerSocketed = (IContainerSocketed)container;
        if (held instanceof ItemCircuitBoard) {
            containerSocketed.handleChipsetClick(this.slot);
        } else if (held instanceof ISolderingIron) {
            containerSocketed.handleSolderingIronClick(this.slot);
        }
    }
}

