/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import com.google.common.base.Preconditions;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateManipulator;
import forestry.api.climate.IClimateManipulatorBuilder;
import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateStateHelper;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;

public class ClimateManipulator
implements IClimateManipulator {
    private final IClimateState targetedState;
    private final IClimateState defaultState;
    private final IClimateState currentState;
    private final IClimateState startState;
    private final BiFunction<ClimateType, IClimateManipulator, Float> changeSupplier;
    private final Consumer<IClimateState> onFinish;
    private final boolean backwards;
    private final ClimateType type;

    private ClimateManipulator(IClimateState targetedState, IClimateState defaultState, IClimateState currentState, BiFunction<ClimateType, IClimateManipulator, Float> changeSupplier, Consumer<IClimateState> onFinish, boolean backwards, ClimateType type) {
        IClimateState current = currentState.isPresent() ? currentState : defaultState;
        this.targetedState = targetedState;
        this.defaultState = defaultState;
        this.currentState = current.copy(true);
        this.startState = current;
        this.changeSupplier = changeSupplier;
        this.onFinish = onFinish;
        this.backwards = backwards;
        this.type = type;
    }

    @Override
    public IClimateState getCurrent() {
        return this.currentState;
    }

    @Override
    public IClimateState getStart() {
        return this.startState;
    }

    @Override
    public IClimateState getTarget() {
        return this.targetedState;
    }

    @Override
    public boolean allowsBackwards() {
        return this.backwards;
    }

    @Override
    public IClimateState getDefault() {
        return this.defaultState;
    }

    @Override
    public ClimateType getType() {
        return this.type;
    }

    @Override
    public void finish() {
        if (!this.currentState.equals(this.startState)) {
            this.onFinish.accept(this.currentState);
        }
    }

    @Override
    public IClimateState addChange(boolean simulated) {
        return this.applyChange(true, simulated);
    }

    @Override
    public IClimateState removeChange(boolean simulated) {
        return this.applyChange(false, simulated);
    }

    @Override
    public boolean canAdd() {
        boolean rightDirection;
        IClimateState difference = this.targetedState.subtract(this.startState);
        if (ClimateStateHelper.isZero(this.type, difference)) {
            return true;
        }
        float change = this.changeSupplier.apply(this.type, this).floatValue();
        boolean bl = rightDirection = difference.getClimate(this.type) > 0.0f && change > 0.0f || difference.getClimate(this.type) < 0.0f && change < 0.0f;
        if (!rightDirection) {
            IClimateState diffToDefault = this.startState.subtract(this.defaultState);
            return this.backwards || diffToDefault.getClimate(this.type) > 0.0f && change > 0.0f || diffToDefault.getClimate(this.type) < 0.0f && change < 0.0f;
        }
        return true;
    }

    private IClimateState applyChange(boolean worked, boolean simulated) {
        IClimateState newState;
        IClimateState newDifference;
        float diff;
        boolean rightDirection;
        IClimateState target = worked ? this.targetedState : this.defaultState;
        IClimateState difference = target.subtract(this.startState);
        if (ClimateStateHelper.isZero(this.type, difference)) {
            return ClimateStateHelper.ZERO_STATE;
        }
        float change = this.changeSupplier.apply(this.type, this).floatValue();
        IClimateState changeState = ClimateStateHelper.INSTANCE.create(this.type, change).toMutable();
        boolean bl = rightDirection = difference.getClimate(this.type) > 0.0f && change > 0.0f || difference.getClimate(this.type) < 0.0f && change < 0.0f;
        if (!rightDirection) {
            IClimateState diffToDefault = this.startState.subtract(this.defaultState);
            if (!worked || this.backwards || diffToDefault.getClimate(this.type) > 0.0f && change > 0.0f || diffToDefault.getClimate(this.type) < 0.0f && change < 0.0f) {
                changeState.multiply(-1.0);
            } else {
                return ClimateStateHelper.ZERO_STATE;
            }
        }
        if (ClimateManipulator.canRound(diff = (newDifference = target.subtract(newState = this.startState.add(changeState))).getClimate(this.type))) {
            changeState.add(this.type, diff);
        }
        if (!simulated) {
            this.currentState.add(changeState);
        }
        return changeState;
    }

    private static boolean canRound(float diff) {
        return BigDecimal.valueOf(MathHelper.func_76135_e((float)diff)).setScale(2, 4).floatValue() <= 0.01f;
    }

    public static class Builder
    implements IClimateManipulatorBuilder {
        @Nullable
        private IClimateState targetedState = null;
        @Nullable
        private IClimateState defaultState = null;
        @Nullable
        private IClimateState currentState = null;
        @Nullable
        private BiFunction<ClimateType, IClimateManipulator, Float> changeSupplier = null;
        @Nullable
        private ClimateType type = null;
        private Consumer<IClimateState> onFinish = climateState -> {};
        private boolean backwards = false;

        @Override
        public IClimateManipulatorBuilder setType(ClimateType type) {
            this.type = type;
            return this;
        }

        @Override
        public IClimateManipulatorBuilder setAllowBackwards() {
            this.backwards = true;
            return this;
        }

        @Override
        public IClimateManipulatorBuilder setChangeSupplier(BiFunction<ClimateType, IClimateManipulator, Float> changeSupplier) {
            this.changeSupplier = changeSupplier;
            return this;
        }

        @Override
        public IClimateManipulatorBuilder setOnFinish(Consumer<IClimateState> onFinish) {
            this.onFinish = onFinish;
            return this;
        }

        @Override
        public IClimateManipulatorBuilder setTarget(IClimateState state) {
            this.targetedState = state.toImmutable();
            return this;
        }

        @Override
        public IClimateManipulatorBuilder setDefault(IClimateState state) {
            this.defaultState = state.toImmutable();
            return this;
        }

        @Override
        public IClimateManipulatorBuilder setCurrent(IClimateState state) {
            this.currentState = state.toImmutable();
            return this;
        }

        @Override
        public IClimateManipulator build() {
            Preconditions.checkNotNull((Object)this.targetedState);
            Preconditions.checkNotNull((Object)this.defaultState);
            Preconditions.checkNotNull((Object)this.currentState);
            Preconditions.checkNotNull(this.changeSupplier);
            Preconditions.checkNotNull((Object)((Object)this.type));
            return new ClimateManipulator(this.targetedState, this.defaultState, this.currentState, this.changeSupplier, this.onFinish, this.backwards, this.type);
        }
    }
}

