/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.distribution;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.distribution.Distribution;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DistributionSurface
extends Distribution {
    private final WorldGenerator worldGen;
    private final INumberProvider count;
    private final WeightedBlock[] matList;

    public DistributionSurface(String name, WorldGenerator worldGen, List<WeightedBlock> matList, INumberProvider count, boolean regen) {
        super(name, regen);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList.toArray(new WeightedBlock[matList.size()]);
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = this.count.intValue(world, random, new INumberProvider.DataHolder(pos));
        this.worldGen.func_175904_e();
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int y;
            IBlockState state;
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random) || (state = world.func_180495_p(new BlockPos(x, y = Utils.getSurfaceBlockY(world, x, z), z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) || !WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, this.matList)) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y + 1, z));
        }
        return generated;
    }
}

