/*
 * Decompiled with CFR 0.152.
 */
package extracells.models.drive;

import extracells.models.drive.DriveSlotState;
import extracells.models.drive.IECDrive;

public class DriveSlotsState {
    private final DriveSlotState[] slots;

    private DriveSlotsState(DriveSlotState[] slots) {
        this.slots = slots;
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] != null) continue;
            this.slots[i] = DriveSlotState.EMPTY;
        }
    }

    public DriveSlotState getState(int index) {
        if (index >= this.slots.length) {
            return DriveSlotState.EMPTY;
        }
        return this.slots[index];
    }

    public static DriveSlotsState createState(IECDrive drive) {
        DriveSlotState[] slots = new DriveSlotState[drive.getCellCount()];
        for (int i = 0; i < drive.getCellCount(); ++i) {
            if (!drive.isPowered()) {
                if (drive.getCellStatus(i) != 0) {
                    slots[i] = DriveSlotState.OFFLINE;
                    continue;
                }
                slots[i] = DriveSlotState.EMPTY;
                continue;
            }
            slots[i] = DriveSlotState.fromCellStatus(drive.getCellStatus(i));
        }
        return new DriveSlotsState(slots);
    }
}

