/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.implementations.parts.IPartCable;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.util.AEPartLocation;
import javax.annotation.Nullable;

public class CableBusStorage {
    private IPartCable center;
    private IPart[] sides;
    private IFacadePart[] facades;

    protected IPartCable getCenter() {
        return this.center;
    }

    protected void setCenter(IPartCable center) {
        this.center = center;
    }

    protected IPart getSide(AEPartLocation side) {
        int x = side.ordinal();
        if (this.sides != null && this.sides.length > x) {
            return this.sides[x];
        }
        return null;
    }

    protected void setSide(AEPartLocation side, IPart part) {
        int x = side.ordinal();
        if (this.sides != null && this.sides.length > x && part == null) {
            this.sides[x] = null;
            this.sides = this.shrink(this.sides, true);
        } else if (part != null) {
            this.sides = this.grow(this.sides, x, true);
            this.sides[x] = part;
        }
    }

    private <T> T[] shrink(T[] in, boolean parts) {
        int newSize = -1;
        for (int x = 0; x < in.length; ++x) {
            if (in[x] == null) continue;
            newSize = x;
        }
        if (newSize == -1) {
            return null;
        }
        if (++newSize == in.length) {
            return in;
        }
        Object[] newArray = parts ? new IPart[newSize] : new IFacadePart[newSize];
        System.arraycopy(in, 0, newArray, 0, newSize);
        return newArray;
    }

    private <T> T[] grow(T[] in, int newValue, boolean parts) {
        Object[] newArray;
        if (in != null && in.length > newValue) {
            return in;
        }
        int newSize = newValue + 1;
        Object[] objectArray = newArray = parts ? new IPart[newSize] : new IFacadePart[newSize];
        if (in != null) {
            System.arraycopy(in, 0, newArray, 0, in.length);
        }
        return newArray;
    }

    public IFacadePart getFacade(int x) {
        if (this.facades != null && this.facades.length > x) {
            return this.facades[x];
        }
        return null;
    }

    public void setFacade(int x, @Nullable IFacadePart facade) {
        if (this.facades != null && this.facades.length > x && facade == null) {
            this.facades[x] = null;
            this.facades = this.shrink(this.facades, false);
        } else {
            this.facades = this.grow(this.facades, x, false);
            this.facades[x] = facade;
        }
    }
}

