/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.ic2.energy;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import ic2.api.item.IBackupElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class PoweredItemManager
implements IBackupElectricItemManager {
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double convertedPower;
        double limit = this.getTransferLimit(stack);
        IAEItemPowerStorage poweredItem = (IAEItemPowerStorage)stack.func_77973_b();
        double toAdd = convertedPower = PowerUnits.EU.convertTo(PowerUnits.AE, amount);
        if (!ignoreTransferLimit && amount > limit) {
            toAdd = limit;
        }
        double overflow = poweredItem.injectAEPower(stack, toAdd, simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        double addedAmount = toAdd - (double)((int)overflow);
        return PowerUnits.AE.convertTo(PowerUnits.EU, addedAmount);
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return 0.0;
    }

    public double getCharge(ItemStack stack) {
        IAEItemPowerStorage poweredItem = (IAEItemPowerStorage)stack.func_77973_b();
        return (int)PowerUnits.AE.convertTo(PowerUnits.EU, poweredItem.getAECurrentPower(stack));
    }

    public double getMaxCharge(ItemStack stack) {
        IAEItemPowerStorage poweredItem = (IAEItemPowerStorage)stack.func_77973_b();
        return PowerUnits.AE.convertTo(PowerUnits.EU, poweredItem.getAEMaxPower(stack));
    }

    public boolean canUse(ItemStack stack, double amount) {
        return this.getCharge(stack) > amount;
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        IAEItemPowerStorage poweredItem = (IAEItemPowerStorage)stack.func_77973_b();
        if (this.canUse(stack, amount)) {
            double toUse = PowerUnits.EU.convertTo(PowerUnits.AE, amount);
            poweredItem.extractAEPower(stack, toUse, Actionable.MODULATE);
            return true;
        }
        return false;
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack stack) {
        return null;
    }

    public int getTier(ItemStack stack) {
        return 1;
    }

    public boolean handles(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IAEItemPowerStorage;
    }

    private double getTransferLimit(ItemStack itemStack) {
        return Math.max(32.0, this.getMaxCharge(itemStack) / 200.0);
    }
}

