/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.setup;

import java.lang.reflect.Method;
import mcjty.lib.compat.MainCompatHandler;
import mcjty.lib.setup.DefaultModSetup;
import mcjty.lib.varia.Logging;
import mcjty.rftools.Achievements;
import mcjty.rftools.ForgeEventHandlers;
import mcjty.rftools.RFTools;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.ModBlocks;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.compat.computers.OpenComputersIntegration;
import mcjty.rftools.compat.wheelsupport.WheelSupport;
import mcjty.rftools.compat.xnet.XNetSupport;
import mcjty.rftools.config.ConfigSetup;
import mcjty.rftools.crafting.ModCrafting;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.playerprops.BuffProperties;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.setup.CommandHandler;
import mcjty.rftools.setup.GuiProxy;
import mcjty.rftools.world.ModWorldgen;
import mcjty.rftools.world.WorldTickHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ModSetup
extends DefaultModSetup {
    public boolean rftoolsDimensions = false;
    public boolean xnet = false;
    public boolean top = false;
    public static Method Block_getSilkTouch;

    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        MinecraftForge.EVENT_BUS.register((Object)WorldTickHandler.instance);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RFTools.instance, (IGuiHandler)new GuiProxy());
        CommandHandler.registerCommands();
        RFTools.screenModuleRegistry.registerBuiltins();
        this.reflect();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)RFTools.instance, (tickets, world) -> {});
        this.setupCapabilities();
        RFToolsMessages.registerMessages("rftools");
        ModItems.init();
        ModBlocks.init();
        ModWorldgen.init();
    }

    protected void setupModCompat() {
        MainCompatHandler.registerWaila();
        MainCompatHandler.registerTOP();
        WheelSupport.registerWheel();
        if (Loader.isModLoaded((String)"rftoolsdim")) {
            this.rftoolsDimensions = true;
            Logging.log((String)"RFTools Detected Dimensions addon: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"rftoolsdim", (String)"getDimensionManager", (String)"mcjty.rftools.compat.RFToolsDimensionChecker$GetDimensionManager");
        }
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"mcjty.rftools.compat.theoneprobe.TheOneProbeSupport");
        if (Loader.isModLoaded((String)"xnet")) {
            this.xnet = true;
            Logging.log((String)"RFTools Detected XNet: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"xnet", (String)"getXNet", (String)XNetSupport.GetXNet.class.getName());
        }
        this.top = Loader.isModLoaded((String)"theoneprobe");
        if (Loader.isModLoaded((String)"opencomputers")) {
            OpenComputersIntegration.init();
        }
    }

    protected void setupConfig() {
        ConfigSetup.init();
    }

    private void setupCapabilities() {
        CapabilityManager.INSTANCE.register(BuffProperties.class, (Capability.IStorage)new Capability.IStorage<BuffProperties>(){

            public NBTBase writeNBT(Capability<BuffProperties> capability, BuffProperties instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<BuffProperties> capability, BuffProperties instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
        CapabilityManager.INSTANCE.register(FavoriteDestinationsProperties.class, (Capability.IStorage)new Capability.IStorage<FavoriteDestinationsProperties>(){

            public NBTBase writeNBT(Capability<FavoriteDestinationsProperties> capability, FavoriteDestinationsProperties instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<FavoriteDestinationsProperties> capability, FavoriteDestinationsProperties instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
        CapabilityManager.INSTANCE.register(IModuleProvider.class, (Capability.IStorage)new Capability.IStorage<IModuleProvider>(){

            public NBTBase writeNBT(Capability<IModuleProvider> capability, IModuleProvider instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<IModuleProvider> capability, IModuleProvider instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    public void createTabs() {
        this.createTab("RfTools", () -> new ItemStack((Item)ModItems.rfToolsManualItem));
    }

    private void reflect() {
        Block_getSilkTouch = ReflectionHelper.findMethod(Block.class, (String)"getSilkTouchDrop", (String)"func_180643_i", (Class[])new Class[]{IBlockState.class});
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
        ModCrafting.init();
        SpawnerConfiguration.readMobSpawnAmountConfig(ConfigSetup.mainConfig);
        Achievements.init();
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        ConfigSetup.postInit();
    }
}

