/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen.tree;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.core.def.DefBlock;
import pmp.core.def.DefTree;
import pmp.worldgen.tree.GenTreeBase;

public class GenTreeBaseFruit
extends GenTreeBase {
    protected final DefTree defTree;

    public GenTreeBaseFruit(DefTree defTree, boolean notify) {
        super(defTree, notify);
        this.defTree = defTree;
        this.stateLog = PlantMegaPack.objects.getBlock(DefBlock.LOGWD_FRTWD).func_176223_P();
        this.stateLeaves = PlantMegaPack.objects.getLeaves(this.defTree).func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.stateTreeFruit = PlantMegaPack.objects.getTreeFruit(defTree).func_176223_P();
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        return this.generateFruitTree(world, pos, rand);
    }

    protected boolean generateFruitTree(World world, BlockPos pos, Random rand) {
        if (!this.canTreeGrowAtPos(world, pos)) {
            return false;
        }
        this.generateFruitwoodTrunk(world, pos);
        BlockPos posStart = pos.func_177967_a(EnumFacing.UP, this.height - 1);
        IBlockState woodBlockState = this.stateLog;
        BlockPos posTemp = posStart.func_177967_a(EnumFacing.NORTH, 1);
        world.func_180501_a(posTemp, woodBlockState, 3);
        this.spawnFruit(world, posTemp.func_177977_b());
        posTemp = posStart.func_177967_a(EnumFacing.SOUTH, 1);
        world.func_180501_a(posTemp, woodBlockState, 3);
        this.spawnFruit(world, posTemp.func_177977_b());
        posTemp = posStart.func_177967_a(EnumFacing.EAST, 1);
        world.func_180501_a(posTemp, woodBlockState, 3);
        this.spawnFruit(world, posTemp.func_177977_b());
        posTemp = posStart.func_177967_a(EnumFacing.WEST, 1);
        world.func_180501_a(posTemp, woodBlockState, 3);
        this.spawnFruit(world, posTemp.func_177977_b());
        this.generateRandomLeafLayer(world, rand, posStart, 2, 1, 0, 92);
        this.generateRandomLeafLayer(world, rand, posStart.func_177967_a(EnumFacing.UP, 1), 2, 1, 0, 92);
        this.generateLeafLayer(world, rand, posStart.func_177967_a(EnumFacing.UP, 2), 1, 1, 0);
        return true;
    }
}

