/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen.tree;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.core.def.DefTree;
import pmp.worldgen.tree.GenTreeBase;

public class GenJunglCocon
extends GenTreeBase {
    public GenJunglCocon(DefTree defTree, boolean notify) {
        super(defTree, notify);
        this.stateLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        this.stateLeaves = PlantMegaPack.objects.getLeaves(DefTree.JUNGL_COCON).func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.stateTreeFruit = PlantMegaPack.objects.getTreeFruit(DefTree.JUNGL_COCON).func_176223_P();
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i;
        if (!this.canTreeGrowAtPos(world, pos)) {
            return false;
        }
        this.height = 5 + rand.nextInt(5);
        BlockPos posStart = pos.func_177967_a(EnumFacing.DOWN, 1);
        int j = 2 + rand.nextInt(2);
        for (i = 0; i < j; ++i) {
            posStart = posStart.func_177967_a(EnumFacing.UP, 1);
            world.func_180501_a(posStart, this.stateLog, 3);
        }
        EnumFacing trunkBend = this.getRandomDirection(rand);
        posStart = posStart.func_177967_a(trunkBend, 1);
        j = this.height - i - 1;
        for (i = 0; i < j; ++i) {
            posStart = posStart.func_177967_a(EnumFacing.UP, 1);
            world.func_180501_a(posStart, this.stateLog, 3);
        }
        posStart = posStart.func_177967_a(trunkBend.func_176734_d(), 1);
        for (i = 0; i < 2; ++i) {
            posStart = posStart.func_177967_a(EnumFacing.UP, 1);
            world.func_180501_a(posStart, this.stateLog, 3);
        }
        BlockPos posTemp = posStart.func_177967_a(EnumFacing.NORTH, 1);
        world.func_180501_a(posTemp, this.stateLog.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), 3);
        this.spawnFruit(world, posTemp.func_177977_b());
        posTemp = posStart.func_177967_a(EnumFacing.SOUTH, 1);
        world.func_180501_a(posTemp, this.stateLog.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), 3);
        this.spawnFruit(world, posTemp.func_177977_b());
        posTemp = posStart.func_177967_a(EnumFacing.EAST, 1);
        world.func_180501_a(posTemp, this.stateLog.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), 3);
        this.spawnFruit(world, posTemp.func_177977_b());
        posTemp = posStart.func_177967_a(EnumFacing.WEST, 1);
        world.func_180501_a(posTemp, this.stateLog.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), 3);
        this.spawnFruit(world, posTemp.func_177977_b());
        posTemp = posStart.func_177967_a(EnumFacing.UP, 1);
        this.spawnLeafBlock(world, posTemp);
        posTemp = posStart.func_177967_a(EnumFacing.NORTH, 2);
        this.generatePalmLeaf(world, posTemp, EnumFacing.NORTH);
        posTemp = posStart.func_177967_a(EnumFacing.SOUTH, 2);
        this.generatePalmLeaf(world, posTemp, EnumFacing.SOUTH);
        posTemp = posStart.func_177967_a(EnumFacing.EAST, 2);
        this.generatePalmLeaf(world, posTemp, EnumFacing.EAST);
        posTemp = posStart.func_177967_a(EnumFacing.WEST, 2);
        this.generatePalmLeaf(world, posTemp, EnumFacing.WEST);
        return true;
    }
}

