/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen;

import net.minecraft.util.math.BlockPos;
import pmp.PlantMegaPack;
import pmp.core.data.DataHabitatPlant;
import pmp.core.data.DataHabitatTree;
import pmp.worldgen.GenEpiphyte;
import pmp.worldgen.GenPlant;
import pmp.worldgen.GenTree;
import pmp.worldgen.GenVine;
import pmp.worldgen.WorldgenGenData;

public class WorldgenOverworld {
    public void generate(WorldgenGenData genData) {
        if (PlantMegaPack.settings.worldgenSpawnTrees) {
            this.generateTrees(genData);
        }
        if (PlantMegaPack.settings.worldgenSpawnPlants) {
            this.generatePlants(genData);
        }
    }

    private void generatePlants(WorldgenGenData genData) {
        int chunkX = genData.posChunk.func_177958_n();
        int chunkZ = genData.posChunk.func_177952_p();
        for (int ix = 0; ix < 16; ++ix) {
            block8: for (int iz = 0; iz < 16; ++iz) {
                BlockPos pos = new BlockPos(chunkX + ix + 8, 0, chunkZ + iz + 8);
                if (!genData.initSpawnLocation(pos) || !genData.canSpawnPlant()) continue;
                switch (genData.defHabitat) {
                    case TREE_EPIPHYTE: {
                        this.generateEpiphyte(genData);
                        continue block8;
                    }
                    case TREE_VINE: {
                        this.generateVine(genData);
                        continue block8;
                    }
                    case LAND_BIOME_EDGE: 
                    case LAND_OPEN: 
                    case LAND_SLOPE: 
                    case LAND_WATER_EDGE: {
                        this.generateLandPlant(genData);
                        continue block8;
                    }
                    case LAND_SHADE: 
                    case LAND_SLOPE_SHADE: 
                    case LAND_WATER_EDGE_SHADE: 
                    case LAND_TREE_BASE: {
                        this.generateLandPlant(genData);
                        continue block8;
                    }
                    case FRESHWATER_DEEP: 
                    case FRESHWATER_FLOATING: 
                    case FRESHWATER_MARGIN: 
                    case MARINE_DEEP: 
                    case MARINE_FLOATING: 
                    case MARINE_MARGIN: {
                        this.generateWaterPlant(genData);
                        continue block8;
                    }
                }
            }
        }
    }

    private void generateTrees(WorldgenGenData genData) {
        int chunkX = genData.posChunk.func_177958_n();
        int chunkZ = genData.posChunk.func_177952_p();
        for (int ix = 0; ix < 16; ++ix) {
            block4: for (int iz = 0; iz < 16; ++iz) {
                BlockPos pos = new BlockPos(chunkX + ix + 8, 0, chunkZ + iz + 8);
                if (!genData.initSpawnLocation(pos) || !genData.canSpawnTree()) continue;
                switch (genData.defHabitat) {
                    case LAND_BIOME_EDGE: 
                    case LAND_OPEN: 
                    case LAND_SLOPE: 
                    case LAND_WATER_EDGE: {
                        this.generateTree(genData);
                        continue block4;
                    }
                }
            }
        }
    }

    private void generateLandPlant(WorldgenGenData genData) {
        if (genData.random.nextInt(100) > PlantMegaPack.settings.worldgenMasterGenRate) {
            return;
        }
        DataHabitatPlant plant = genData.dataHabitat.getRandomPlant(genData.random);
        if (plant != null) {
            GenPlant.generatePlantCluster(genData, plant);
        }
    }

    private void generateEpiphyte(WorldgenGenData genData) {
        if (genData.random.nextInt(100) > PlantMegaPack.settings.worldgenMasterGenRate) {
            return;
        }
        DataHabitatPlant plant = genData.dataHabitat.getRandomPlant(genData.random);
        if (plant != null) {
            GenEpiphyte.generateEpiphyte(genData, plant);
        }
    }

    private void generateTree(WorldgenGenData genData) {
        if (genData.random.nextInt(100) > PlantMegaPack.settings.worldgenMasterGenRate) {
            return;
        }
        DataHabitatTree tree = genData.dataHabitat.getRandomTree(genData.random);
        if (tree != null) {
            GenTree.generateTree(genData, tree);
        }
    }

    private void generateVine(WorldgenGenData genData) {
        if (genData.random.nextInt(100) > PlantMegaPack.settings.worldgenMasterGenRate) {
            return;
        }
        DataHabitatPlant plant = genData.dataHabitat.getRandomPlant(genData.random);
        if (plant != null) {
            GenVine.generateVine(genData, plant);
        }
    }

    private void generateWaterPlant(WorldgenGenData genData) {
        if (genData.random.nextInt(100) > PlantMegaPack.settings.worldgenMasterGenRate) {
            return;
        }
        DataHabitatPlant plant = genData.dataHabitat.getRandomPlant(genData.random);
        if (plant != null) {
            GenPlant.generatePlantCluster(genData, plant);
        }
    }
}

