/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;
import pmp.PlantMegaPack;

public abstract class WorldgenHelpers {
    public static boolean canSpawnEpiphyteAtPos(World world, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_185904_a();
        return material.func_76222_j() && material != Material.field_151584_j && material != Material.field_151582_l;
    }

    public static boolean canTreeSpawnAtPos(World world, BlockPos pos, int radius) {
        if (!(radius >= 1 && radius <= 4 || world.func_175710_j(pos.func_177984_a()))) {
            return false;
        }
        for (int ix = -radius; ix <= radius; ++ix) {
            for (int iz = -radius; iz <= radius; ++iz) {
                BlockPos posTarget = world.func_175672_r(new BlockPos(pos.func_177958_n() + ix, pos.func_177956_o(), pos.func_177952_p() + iz));
                if (world.func_175710_j(posTarget.func_177984_a())) continue;
                return false;
            }
        }
        return true;
    }

    public static BlockPos moveSpawnToGround(World world, BlockPos pos) {
        BlockPos posTarget = pos.func_177982_a(0, -1, 0);
        IBlockState statePos = world.func_180495_p(posTarget);
        IBlockState stateSoil = world.func_180495_p(posTarget.func_177977_b());
        while (statePos.func_185904_a().func_76222_j() && !stateSoil.func_185904_a().func_76222_j()) {
            posTarget = posTarget.func_177982_a(0, -1, 0);
            statePos = world.func_180495_p(posTarget);
            stateSoil = world.func_180495_p(posTarget.func_177977_b());
        }
        return posTarget;
    }

    public static EnumFacing findAdjacentSpawnLocation(World world, BlockPos pos) {
        BlockPos posGround = pos.func_177977_b();
        if (WorldgenHelpers.isLandPlantSoilBlock(world, posGround.func_177978_c())) {
            return EnumFacing.NORTH;
        }
        if (WorldgenHelpers.isLandPlantSoilBlock(world, posGround.func_177968_d())) {
            return EnumFacing.SOUTH;
        }
        if (WorldgenHelpers.isLandPlantSoilBlock(world, posGround.func_177974_f())) {
            return EnumFacing.WEST;
        }
        if (WorldgenHelpers.isLandPlantSoilBlock(world, posGround.func_177978_c())) {
            return EnumFacing.EAST;
        }
        return null;
    }

    public static EnumFacing getSolidFacing(World world, BlockPos pos) {
        if (world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH)) {
            return EnumFacing.NORTH;
        }
        if (world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST)) {
            return EnumFacing.WEST;
        }
        if (world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST)) {
            return EnumFacing.EAST;
        }
        if (world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH)) {
            return EnumFacing.SOUTH;
        }
        return null;
    }

    public static BlockLog.EnumAxis getLogAxisFromDirection(EnumFacing direction) {
        if (direction == EnumFacing.NORTH || direction == EnumFacing.SOUTH) {
            return BlockLog.EnumAxis.Z;
        }
        return BlockLog.EnumAxis.X;
    }

    public static BlockPos getTopSolidOrLiquidBlockIncludeLeaves(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public static EnumFacing isAdjacentToBlockMaterial(World world, BlockPos pos, Material material) {
        IBlockState state = world.func_180495_p(pos.func_177968_d());
        if (state.func_185904_a() == material) {
            return EnumFacing.SOUTH;
        }
        state = world.func_180495_p(pos.func_177976_e());
        if (state.func_185904_a() == material) {
            return EnumFacing.WEST;
        }
        state = world.func_180495_p(pos.func_177978_c());
        if (state.func_185904_a() == material) {
            return EnumFacing.NORTH;
        }
        state = world.func_180495_p(pos.func_177974_f());
        if (state.func_185904_a() == material) {
            return EnumFacing.EAST;
        }
        return null;
    }

    public static boolean isAdjacentToBlockMaterialDiagonal(World world, BlockPos pos, Material material) {
        for (int ix = -1; ix <= 1; ++ix) {
            for (int iz = -1; iz <= 1; ++iz) {
                BlockPos posTest = pos.func_177982_a(ix, 0, iz);
                IBlockState state = world.func_180495_p(posTest);
                if (state.func_185904_a() != material) continue;
                return true;
            }
        }
        return false;
    }

    public static Biome isAdjacentToDifferentBiome(Biome biome, World world, BlockPos pos, int radius) {
        for (int ix = -radius; ix <= radius; ++ix) {
            for (int iz = -radius; iz <= radius; ++iz) {
                BlockPos posTarget = new BlockPos(pos.func_177958_n() + ix, pos.func_177956_o(), pos.func_177952_p() + iz);
                Biome biomeTarget = world.getBiomeForCoordsBody(posTarget);
                if (biome == biomeTarget) continue;
                return biomeTarget;
            }
        }
        return null;
    }

    public static boolean isDirtBlock(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block instanceof BlockDirt || block instanceof BlockGrass || material == Material.field_151577_b;
    }

    public static boolean isFarmlandBlock(IBlockState state) {
        return state.func_177230_c() instanceof BlockFarmland;
    }

    public static boolean isLeavesBlock(IBlockState state) {
        return state.func_185904_a() == Material.field_151584_j;
    }

    public static boolean isLogBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos);
    }

    public static boolean isPlantBlock(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151570_A || material == Material.field_151585_k || material == Material.field_151582_l;
    }

    public static boolean isSandBlock(IBlockState state) {
        return state.func_185904_a() == Material.field_151595_p;
    }

    public static EnumFacing isAdjacentToTree(World world, BlockPos pos) {
        if (WorldgenHelpers.isLogBlock(world, pos.func_177968_d())) {
            return EnumFacing.SOUTH;
        }
        if (WorldgenHelpers.isLogBlock(world, pos.func_177974_f())) {
            return EnumFacing.EAST;
        }
        if (WorldgenHelpers.isLogBlock(world, pos.func_177976_e())) {
            return EnumFacing.WEST;
        }
        if (WorldgenHelpers.isLogBlock(world, pos.func_177978_c())) {
            return EnumFacing.NORTH;
        }
        return null;
    }

    public static boolean isGroundSloped(World world, BlockPos pos, int radius) {
        int slopeCount = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos posTarget = world.func_175672_r(pos.func_177982_a(x, 0, z));
                if (posTarget.func_177956_o() == pos.func_177956_o()) continue;
                ++slopeCount;
            }
        }
        return slopeCount > PlantMegaPack.settings.worldgenThresholdSlope;
    }

    public static boolean isAquaticPlantSoilBlock(IBlockState stateSoil) {
        if (stateSoil.func_185904_a() == Material.field_151595_p) {
            return true;
        }
        Block block = stateSoil.func_177230_c();
        return block instanceof BlockDirt || block instanceof BlockGravel;
    }

    public static boolean isLandPlantSoilBlock(World world, BlockPos pos) {
        IBlockState stateSoil = world.func_180495_p(pos);
        return stateSoil.func_177230_c().canSustainPlant(stateSoil, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)Blocks.field_150328_O);
    }

    public static boolean isTreeSoilBlock(World world, BlockPos pos) {
        IBlockState stateSoil = world.func_180495_p(pos);
        if (stateSoil.func_185904_a() == Material.field_151595_p) {
            return true;
        }
        return WorldgenHelpers.isLandPlantSoilBlock(world, pos);
    }

    public static boolean isSurroundedByWater(World world, BlockPos posSpawn) {
        for (int ix = -1; ix <= 1; ++ix) {
            for (int iz = -1; iz <= 1; ++iz) {
                if (world.func_180495_p(posSpawn.func_177982_a(ix, 0, iz)).func_185904_a() == Material.field_151586_h) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNearWater(World world, BlockPos pos) {
        for (int ix = -1; ix <= 1; ++ix) {
            for (int iz = -1; iz <= 1; ++iz) {
                BlockPos posTarget = new BlockPos(pos.func_177958_n() + ix, pos.func_177956_o(), pos.func_177952_p() + iz);
                if (world.func_180495_p(posTarget = world.func_175672_r(posTarget)).func_185904_a() != Material.field_151586_h) continue;
                return true;
            }
        }
        return false;
    }

    public static float getNearbyAverageTemp(World world, BlockPos pos, int radius) {
        float averageTemp = 0.0f;
        BiomeProvider provider = world.func_72959_q();
        Chunk chunk = world.func_175726_f(pos);
        BlockPos posTarget = pos.func_177982_a(-radius, 0, -radius);
        averageTemp += chunk.func_177411_a(posTarget, provider).func_180626_a(posTarget);
        posTarget = pos.func_177982_a(0, 0, -radius);
        averageTemp += chunk.func_177411_a(posTarget, provider).func_180626_a(posTarget);
        posTarget = pos.func_177982_a(radius, 0, -radius);
        averageTemp += chunk.func_177411_a(posTarget, provider).func_180626_a(posTarget);
        posTarget = pos.func_177982_a(-radius, 0, 0);
        averageTemp += chunk.func_177411_a(posTarget, provider).func_180626_a(posTarget);
        posTarget = pos.func_177982_a(radius, 0, 0);
        averageTemp += chunk.func_177411_a(posTarget, provider).func_180626_a(posTarget);
        posTarget = pos.func_177982_a(-radius, 0, radius);
        averageTemp += chunk.func_177411_a(posTarget, provider).func_180626_a(posTarget);
        posTarget = pos.func_177982_a(0, 0, radius);
        averageTemp += chunk.func_177411_a(posTarget, provider).func_180626_a(posTarget);
        posTarget = pos.func_177982_a(radius, 0, radius);
        return (averageTemp += chunk.func_177411_a(posTarget, provider).func_180626_a(posTarget)) / 8.0f;
    }
}

