/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IPlantable;
import pmp.PlantMegaPack;
import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.def.DefHabitat;
import pmp.core.type.TypeBiome;
import pmp.worldgen.WorldgenHelpers;

public class WorldgenGenData {
    public World world;
    public Random random;
    public BlockPos posChunk;
    public Biome biome;
    public Biome biomeAdjacent;
    public TypeBiome typeBiome;
    public TypeBiome typeBiomeAdjacent;
    public DataBiome dataBiome;
    public BlockPos posSpawn;
    public EnumFacing spawnFacing;
    public DefHabitat defHabitat;
    public DataHabitat dataHabitat;
    public boolean canSpawnTree;

    public void initChunkData(World world, Random random, int chunkX, int chunkZ) {
        this.world = world;
        this.random = random;
        this.posChunk = new BlockPos(chunkX * 16, world.func_181545_F(), chunkZ * 16);
    }

    public boolean initSpawnLocation(BlockPos pos) {
        this.resetSpawnData();
        this.posSpawn = this.world.func_175672_r(pos);
        this.biome = this.world.getBiomeForCoordsBody(this.posSpawn);
        this.typeBiome = TypeBiome.getBiomeType(this.world, this.biome, this.posSpawn);
        if (this.typeBiome == null) {
            return false;
        }
        this.dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.typeBiome);
        if (this.dataBiome == null) {
            return false;
        }
        this.defHabitat = this.getHabitatFromLocation(this.posSpawn);
        if (this.defHabitat == null || !this.dataBiome.habitats.containsKey((Object)this.defHabitat)) {
            return false;
        }
        this.dataHabitat = this.dataBiome.habitats.get((Object)this.defHabitat);
        return this.dataHabitat != null;
    }

    public DefHabitat getHabitatFromLocation(BlockPos pos) {
        boolean biomeEdge;
        IBlockState stateSoil = this.world.func_180495_p(this.posSpawn.func_177977_b());
        IBlockState stateSpawn = this.world.func_180495_p(this.posSpawn);
        IBlockState stateAbove = this.world.func_180495_p(this.posSpawn.func_177984_a());
        if (stateSpawn.func_185904_a() == Material.field_151586_h) {
            if (WorldgenHelpers.isAquaticPlantSoilBlock(stateSoil)) {
                if (stateAbove.func_185904_a() == Material.field_151586_h) {
                    return this.typeBiome == TypeBiome.BEACC || this.typeBiome == TypeBiome.BEACW || this.typeBiome == TypeBiome.OCEAN ? DefHabitat.MARINE_DEEP : DefHabitat.FRESHWATER_DEEP;
                }
                if (stateAbove.func_185904_a() == Material.field_151579_a) {
                    if (WorldgenHelpers.isSurroundedByWater(this.world, this.posSpawn)) {
                        this.posSpawn = this.posSpawn.func_177984_a();
                        return this.typeBiome == TypeBiome.BEACC || this.typeBiome == TypeBiome.BEACW || this.typeBiome == TypeBiome.OCEAN ? DefHabitat.MARINE_FLOATING : DefHabitat.FRESHWATER_FLOATING;
                    }
                    this.posSpawn = this.posSpawn.func_177984_a();
                    return this.typeBiome == TypeBiome.BEACC || this.typeBiome == TypeBiome.BEACW || this.typeBiome == TypeBiome.OCEAN ? DefHabitat.MARINE_MARGIN : DefHabitat.FRESHWATER_MARGIN;
                }
            }
            return null;
        }
        if (stateSpawn.func_185904_a() == Material.field_151584_j) {
            if (stateSoil.func_177230_c().isWood((IBlockAccess)this.world, this.posSpawn.func_177977_b())) {
                return this.locateVineSpawnPos() ? DefHabitat.TREE_VINE : null;
            }
            this.posSpawn = WorldgenHelpers.moveSpawnToGround(this.world, this.posSpawn);
            stateSoil = this.world.func_180495_p(this.posSpawn.func_177977_b());
            stateAbove = this.world.func_180495_p(this.posSpawn.func_177984_a());
        }
        if (!stateSoil.func_177230_c().canSustainPlant(stateSoil, (IBlockAccess)this.world, this.posSpawn.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150328_O) && stateSoil.func_185904_a() != Material.field_151595_p) {
            return null;
        }
        boolean shaded = !this.world.func_175678_i(this.posSpawn.func_177984_a());
        boolean sloped = WorldgenHelpers.isGroundSloped(this.world, this.posSpawn, 2);
        this.spawnFacing = WorldgenHelpers.isAdjacentToTree(this.world, this.posSpawn);
        boolean treeBase = this.spawnFacing != null;
        this.canSpawnTree = !shaded && WorldgenHelpers.canTreeSpawnAtPos(this.world, this.posSpawn, PlantMegaPack.settings.worldgenThresholdTreeSpawnRadius);
        this.biomeAdjacent = WorldgenHelpers.isAdjacentToDifferentBiome(this.biome, this.world, this.posSpawn, PlantMegaPack.settings.worldgenBiomeEdgeDetectRadius);
        boolean bl = biomeEdge = this.biomeAdjacent != null;
        if (WorldgenHelpers.isAdjacentToBlockMaterialDiagonal(this.world, this.posSpawn.func_177977_b(), Material.field_151586_h)) {
            return shaded ? DefHabitat.LAND_WATER_EDGE_SHADE : DefHabitat.LAND_WATER_EDGE;
        }
        if (treeBase) {
            return this.locateEpiphyteSpawnPos() ? DefHabitat.TREE_EPIPHYTE : DefHabitat.LAND_TREE_BASE;
        }
        if (biomeEdge) {
            return sloped ? DefHabitat.LAND_BIOME_EDGE_SLOPE : DefHabitat.LAND_BIOME_EDGE;
        }
        if (sloped) {
            return shaded ? DefHabitat.LAND_SLOPE_SHADE : DefHabitat.LAND_SLOPE;
        }
        return shaded ? DefHabitat.LAND_SHADE : DefHabitat.LAND_OPEN;
    }

    private void resetSpawnData() {
        this.posSpawn = null;
        this.biome = null;
        this.biomeAdjacent = null;
        this.typeBiome = null;
        this.dataBiome = null;
        this.defHabitat = null;
        this.dataHabitat = null;
        this.spawnFacing = null;
        this.canSpawnTree = false;
    }

    public boolean canSpawnPlant() {
        boolean canSpawnBiome = this.random.nextInt(100) < this.dataBiome.worldgenRatePlants;
        boolean canSpawnHabitat = this.random.nextInt(100) < this.dataHabitat.worldgenRatePlants;
        return canSpawnBiome && canSpawnHabitat;
    }

    public boolean canSpawnTree() {
        if (!this.canSpawnTree) {
            return false;
        }
        boolean canSpawnBiome = this.random.nextInt(100) < this.dataBiome.worldgenRateTrees;
        boolean canSpawnHabitat = this.random.nextInt(100) < this.dataHabitat.worldgenRateTrees;
        return canSpawnBiome && canSpawnHabitat;
    }

    private boolean locateEpiphyteSpawnPos() {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        BlockPos posTarget = new BlockPos((Vec3i)this.posSpawn.func_177984_a());
        while (WorldgenHelpers.isAdjacentToTree(this.world, posTarget) == this.spawnFacing) {
            if (WorldgenHelpers.canSpawnEpiphyteAtPos(this.world, posTarget)) {
                heights.add(posTarget.func_177956_o());
            }
            posTarget = posTarget.func_177984_a();
        }
        if (heights.isEmpty()) {
            return false;
        }
        this.posSpawn = new BlockPos(this.posSpawn.func_177958_n(), ((Integer)heights.get(this.random.nextInt(heights.size()))).intValue(), this.posSpawn.func_177952_p());
        return true;
    }

    private boolean locateVineSpawnPos() {
        int randInt = this.random.nextInt(100);
        EnumFacing direction = randInt < 25 ? EnumFacing.NORTH : (randInt < 50 ? EnumFacing.EAST : (randInt < 75 ? EnumFacing.SOUTH : EnumFacing.WEST));
        BlockPos posTarget = this.posSpawn.func_177977_b().func_177972_a(direction);
        IBlockState stateTarget = this.world.func_180495_p(posTarget);
        IBlockState stateBelow = this.world.func_180495_p(posTarget.func_177977_b());
        while (stateTarget.func_185904_a() == Material.field_151584_j) {
            posTarget = posTarget.func_177972_a(direction);
            stateTarget = this.world.func_180495_p(posTarget);
            stateBelow = this.world.func_180495_p(posTarget.func_177977_b());
            if (stateBelow.func_185904_a() != Material.field_151584_j) continue;
            posTarget = posTarget.func_177972_a(direction).func_177977_b();
            stateTarget = this.world.func_180495_p(posTarget);
            stateBelow = this.world.func_180495_p(posTarget.func_177977_b());
        }
        if (stateTarget.func_185904_a() == Material.field_151579_a) {
            this.posSpawn = new BlockPos((Vec3i)posTarget);
            this.spawnFacing = direction.func_176734_d();
            return true;
        }
        return false;
    }
}

