/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen;

import java.util.Random;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.block.BlockCropDouble;
import pmp.block.BlockCropSingle;
import pmp.block.BlockPlantBamboo;
import pmp.block.BlockPlantClimbing;
import pmp.block.BlockPlantDouble;
import pmp.block.BlockPlantLarge;
import pmp.block.BlockPlantMedium;
import pmp.core.data.DataHabitatPlant;
import pmp.core.def.DefPlant;
import pmp.core.variant.VariantBlockHalf;
import pmp.core.variant.VariantBlockSegment;
import pmp.worldgen.WorldgenGenData;
import pmp.worldgen.WorldgenHelpers;

public abstract class GenPlant {
    public static void generatePlantCluster(WorldgenGenData genData, DataHabitatPlant dataPlant) {
        BlockPos posSpawn = new BlockPos((Vec3i)genData.posSpawn);
        if (GenPlant.canPlantSpawnAtLocation(genData.world, posSpawn, dataPlant.getDefPlant(), genData.dataBiome.plantCanReplacePlants, genData.dataBiome.plantCanReplaceSnow)) {
            GenPlant.spawnPlant(genData.world, posSpawn, genData.random, dataPlant.getDefPlant());
        }
        if (dataPlant.clusterRadius < 1 || dataPlant.clusterRadius > 8 || dataPlant.clusterChance < 1 || dataPlant.clusterChance > 100) {
            return;
        }
        int spawnPosElevation = genData.posSpawn.func_177956_o();
        for (int ix = -dataPlant.clusterRadius; ix <= dataPlant.clusterRadius; ++ix) {
            for (int iz = -dataPlant.clusterRadius; iz <= dataPlant.clusterRadius; ++iz) {
                if (genData.random.nextInt(100) >= dataPlant.clusterChance) continue;
                posSpawn = new BlockPos(genData.posSpawn.func_177958_n() + ix, genData.world.func_181545_F(), genData.posSpawn.func_177952_p() + iz);
                if (genData.world.func_180495_p(posSpawn = genData.world.func_175672_r(posSpawn)).func_185904_a() == Material.field_151586_h && genData.world.func_180495_p(posSpawn.func_177984_a()).func_185904_a() == Material.field_151579_a) {
                    posSpawn = posSpawn.func_177984_a();
                }
                if (Math.abs(spawnPosElevation - posSpawn.func_177956_o()) > dataPlant.maxElevRange || !GenPlant.canPlantSpawnAtLocation(genData.world, posSpawn, dataPlant.getDefPlant(), genData.dataBiome.plantCanReplacePlants, genData.dataBiome.plantCanReplaceSnow)) continue;
                GenPlant.spawnPlant(genData.world, posSpawn, genData.random, dataPlant.getDefPlant());
            }
        }
    }

    public static boolean canPlantSpawnAtLocation(World world, BlockPos pos, DefPlant defPlant, boolean canReplacePlants, boolean canReplaceSnow) {
        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        IBlockState stateSpawn = world.func_180495_p(pos);
        IBlockState stateSoil = world.func_180495_p(pos.func_177977_b());
        if (defPlant.isFloatingPlant()) {
            if (stateSpawn.func_185904_a() != Material.field_151579_a) {
                return false;
            }
            if (stateSoil.func_185904_a() != Material.field_151586_h) {
                return false;
            }
            return !defPlant.isDoublePlant() || stateAbove.func_185904_a() == Material.field_151579_a;
        }
        if (defPlant.isImmersedPlant()) {
            if (stateSpawn.func_185904_a() != Material.field_151579_a) {
                return false;
            }
            if (stateSoil.func_185904_a() != Material.field_151586_h) {
                return false;
            }
            if (defPlant.isDoublePlant() && stateAbove.func_185904_a() != Material.field_151579_a) {
                return false;
            }
            return WorldgenHelpers.isLandPlantSoilBlock(world, pos.func_177979_c(2));
        }
        if (defPlant.isSubmergedPlant()) {
            if (stateAbove.func_185904_a() != Material.field_151586_h) {
                return false;
            }
            return WorldgenHelpers.isAquaticPlantSoilBlock(stateSoil);
        }
        if (!(canReplacePlants || stateSpawn.func_185904_a() != Material.field_151577_b && stateSpawn.func_185904_a() != Material.field_151585_k && stateSpawn.func_185904_a() != Material.field_151582_l)) {
            return false;
        }
        if (!canReplaceSnow && stateSpawn.func_185904_a() == Material.field_151597_y) {
            return false;
        }
        if (stateSoil.func_177230_c() instanceof BlockFarmland || stateSoil.func_177230_c().isWood((IBlockAccess)world, pos.func_177977_b()) || stateSoil.func_185904_a() == Material.field_151585_k || stateSpawn.func_185904_a() == Material.field_151586_h) {
            return false;
        }
        if (defPlant.isDoublePlant() || defPlant.isLargePlant()) {
            if (stateAbove.func_185904_a() != Material.field_151579_a) {
                return false;
            }
            if (defPlant.isLargePlant() && world.func_180495_p(pos.func_177981_b(2)).func_185904_a() != Material.field_151579_a) {
                return false;
            }
        }
        if (stateSpawn.func_185904_a() == Material.field_151584_j) {
            return false;
        }
        if (stateSoil.func_177230_c() == Blocks.field_150391_bh) {
            return false;
        }
        return defPlant.canGrowOnSand ? WorldgenHelpers.isTreeSoilBlock(world, pos.func_177977_b()) : WorldgenHelpers.isLandPlantSoilBlock(world, pos.func_177977_b());
    }

    public static void spawnPlant(World world, BlockPos pos, Random rand, DefPlant plant) {
        IBlockState statePlant = PlantMegaPack.objects.getPlant(plant).func_176223_P();
        switch (plant.plantType) {
            case CROPA: 
            case CROPF: {
                world.func_180501_a(pos, statePlant.func_177226_a((IProperty)BlockCropSingle.field_176488_a, (Comparable)Integer.valueOf(7)), 2);
                break;
            }
            case CROPS: 
            case BBUSH: {
                world.func_180501_a(pos, statePlant.func_177226_a((IProperty)BlockCropSingle.field_176488_a, (Comparable)Integer.valueOf(7)), 2);
                break;
            }
            case CROPD: {
                world.func_180501_a(pos, statePlant.func_177226_a(BlockCropDouble.HALF, (Comparable)((Object)VariantBlockHalf.BOTTOM)).func_177226_a((IProperty)BlockCropDouble.field_176488_a, (Comparable)Integer.valueOf(7)), 2);
                world.func_180501_a(pos.func_177984_a(), statePlant.func_177226_a(BlockCropDouble.HALF, (Comparable)((Object)VariantBlockHalf.TOP)).func_177226_a((IProperty)BlockCropDouble.field_176488_a, (Comparable)Integer.valueOf(7)), 2);
                break;
            }
            case BAMB: {
                GenPlant.spawnBambooPlant(world, pos, rand, statePlant);
                break;
            }
            case CLIMB: {
                GenPlant.spawnClimbingPlant(world, pos, rand, statePlant);
                break;
            }
            case DOUBL: {
                world.func_180501_a(pos, statePlant.func_177226_a(BlockPlantDouble.HALF, (Comparable)((Object)VariantBlockHalf.BOTTOM)), 2);
                world.func_180501_a(pos.func_177984_a(), statePlant.func_177226_a(BlockPlantDouble.HALF, (Comparable)((Object)VariantBlockHalf.TOP)), 2);
                break;
            }
            case IMMED: {
                world.func_180501_a(pos, statePlant.func_177226_a(BlockPlantDouble.HALF, (Comparable)((Object)VariantBlockHalf.BOTTOM)), 2);
                world.func_180501_a(pos.func_177984_a(), statePlant.func_177226_a(BlockPlantDouble.HALF, (Comparable)((Object)VariantBlockHalf.TOP)), 2);
                break;
            }
            case FLOAT: 
            case FLFLA: 
            case FLFLW: 
            case FLOWR: 
            case IMMER: 
            case GRNDC: 
            case SINGL: 
            case SINGF: 
            case SUBME: {
                world.func_180501_a(pos, statePlant, 2);
                break;
            }
            case MEDIU: {
                world.func_180501_a(pos, statePlant.func_177226_a(BlockPlantMedium.SEGMENT, (Comparable)((Object)VariantBlockHalf.BOTTOM)), 2);
                world.func_180501_a(pos.func_177984_a(), statePlant.func_177226_a(BlockPlantMedium.SEGMENT, (Comparable)((Object)VariantBlockHalf.TOP)), 2);
                break;
            }
            case LARGE: {
                world.func_180501_a(pos, statePlant.func_177226_a(BlockPlantLarge.SEGMENT, (Comparable)((Object)VariantBlockSegment.BOTTOM)), 2);
                world.func_180501_a(pos.func_177984_a(), statePlant.func_177226_a(BlockPlantLarge.SEGMENT, (Comparable)((Object)VariantBlockSegment.MIDDLE)), 2);
                world.func_180501_a(pos.func_177981_b(2), statePlant.func_177226_a(BlockPlantLarge.SEGMENT, (Comparable)((Object)VariantBlockSegment.TOP)), 2);
                break;
            }
            case SUBMK: {
                GenPlant.spawnSeaweedPlant(world, pos, rand, statePlant);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void spawnBambooPlant(World world, BlockPos pos, Random rand, IBlockState statePlant) {
        BlockPlantBamboo block = (BlockPlantBamboo)statePlant.func_177230_c();
        if (!block.func_180671_f(world, pos, statePlant)) {
            return;
        }
        world.func_180501_a(pos, statePlant.func_177226_a((IProperty)BlockPlantBamboo.SEGMENT, (Comparable)Integer.valueOf(0)), 2);
        int randomHeight = Math.max(2, rand.nextInt(PlantMegaPack.settings.plantBambooMaxHeight));
        int segment = -1;
        for (int y = 0; y < randomHeight; ++y) {
            if (++segment > 3) {
                segment = 3;
            }
            if (y == randomHeight - 1) {
                segment = 4;
            }
            world.func_180501_a(pos.func_177981_b(y), statePlant.func_177226_a((IProperty)BlockPlantBamboo.SEGMENT, (Comparable)Integer.valueOf(segment)), 3);
        }
    }

    public static void spawnClimbingPlant(World world, BlockPos pos, Random rand, IBlockState statePlant) {
        EnumFacing facing = WorldgenHelpers.getSolidFacing(world, pos);
        if (facing != null) {
            BlockPlantClimbing climbingBlock = (BlockPlantClimbing)statePlant.func_177230_c();
            IBlockState state = climbingBlock.func_176223_P().func_177226_a((IProperty)BlockPlantClimbing.FACING, (Comparable)facing);
            world.func_180501_a(pos, state, 2);
            int randomHeight = Math.max(2, rand.nextInt(PlantMegaPack.settings.plantClimbingMaxHeight));
            for (int spawnHeight = 0; spawnHeight < randomHeight && climbingBlock.func_176473_a(world, pos, state, world.field_72995_K); ++spawnHeight) {
                climbingBlock.func_176474_b(world, rand, pos, state);
            }
        }
    }

    public static void spawnSeaweedPlant(World world, BlockPos pos, Random rand, IBlockState statePlant) {
        int maxHeight = 0;
        BlockPos posTemp = pos;
        while (statePlant.func_185904_a() == Material.field_151586_h && world.func_180495_p(posTemp.func_177984_a()).func_185904_a() == Material.field_151586_h) {
            posTemp = posTemp.func_177984_a();
            ++maxHeight;
        }
        int height = rand.nextInt(maxHeight);
        if (height > 2) {
            height /= 2;
        }
        if (height > PlantMegaPack.settings.plantKelpMaxHeight) {
            height = PlantMegaPack.settings.plantKelpMaxHeight;
        }
        posTemp = pos;
        for (int i = 0; i < height; ++i) {
            world.func_180501_a(posTemp, statePlant, 2);
            posTemp = posTemp.func_177984_a();
        }
    }
}

