/*
 * Decompiled with CFR 0.152.
 */
package pmp.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.core.def.DefItem;
import pmp.item.ItemTooltips;
import pmp.worldgen.GenPlantPowder;

public class ItemBasePowder
extends Item {
    protected DefItem defItem;

    public ItemBasePowder(DefItem defItem) {
        this.defItem = defItem;
        this.func_77625_d(1);
        this.setPowderMaxDamage();
        this.setNoRepair();
    }

    private void setPowderMaxDamage() {
        int uses = 10;
        switch (this.defItem) {
            case PLNTPW_CON: {
                uses = PlantMegaPack.settings.powderConditionerUses;
                break;
            }
            case PLNTPW_DEF: {
                uses = PlantMegaPack.settings.powderDefoliantUses;
                break;
            }
            case PLNTPW_FER: {
                uses = PlantMegaPack.settings.powderFertilizerUses;
                break;
            }
        }
        this.func_77656_e(uses - 1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        GenPlantPowder powder = new GenPlantPowder();
        if (!powder.applyPowder(world, pos, this.defItem)) {
            return EnumActionResult.FAIL;
        }
        if (!player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            ItemStack itemStack = player.func_184586_b(hand);
            itemStack.func_77972_a(1, (EntityLivingBase)player);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        itemstack.func_77972_a(1, (EntityLivingBase)player);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!world.field_72995_K) {
            stack.func_77972_a(1, entityLiving);
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        ItemTooltips.addOreDictName(tooltip, this.defItem.oreDictName);
        if (PlantMegaPack.settings.tooltipHints) {
            switch (this.defItem) {
                case PLNTPW_CON: {
                    ItemTooltips.addUsageText(tooltip, "gui.plntpw_con");
                    break;
                }
                case PLNTPW_DEF: {
                    ItemTooltips.addUsageText(tooltip, "gui.plntpw_def");
                    break;
                }
                case PLNTPW_FER: {
                    ItemTooltips.addUsageText(tooltip, "gui.plntpw_fer");
                    break;
                }
            }
        }
    }
}

