/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.def.DefHabitat;
import pmp.core.type.TypeBiome;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiCore;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpButton;
import pmp.gui.control.GuiPmpButtonMode;
import pmp.gui.control.GuiPmpListbox;
import pmp.gui.control.GuiPmpListboxState;
import pmp.gui.control.IListboxOwner;
import pmp.gui.screen.GuiBiomeSettings;
import pmp.gui.screen.GuiHabitatMain;

public class GuiWorldBiomes
extends GuiScreenBase
implements IListboxOwner {
    private TypeBiome biomeSelected = null;
    private GuiPmpListbox biomeList;
    private static GuiPmpListboxState listboxState = new GuiPmpListboxState();
    private GuiPmpButton buttonSettings;
    private GuiPmpButton buttonHabitats;

    public GuiWorldBiomes(GuiScreen parentGuiScreen) {
        super(parentGuiScreen, null, GuiButtonLayout.DONE);
        this.name = String.format("%s %s %s", I18n.func_135052_a((String)"gui.customize", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.world_generation", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.biome_types", (Object[])new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getListboxStartX();
        int yPos = this.getButtonRowStartY(2);
        this.biomeList = new GuiPmpListbox(this, xPos, yPos, this.getListboxWidth(), this.getListboxHeight(), this.getFontRenderer().field_78288_b + 2);
        xPos = this.field_146294_l / 2 + 4;
        yPos = this.getButtonRowStartY(2);
        this.buttonSettings = new GuiPmpButton(this, 10, GuiPmpButtonMode.NORMAL, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]) + "...");
        yPos = this.getButtonRowStartY(3);
        this.buttonHabitats = new GuiPmpButton(this, 11, GuiPmpButtonMode.NORMAL, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.habitats", (Object[])new Object[0]) + "...");
        this.populateBiomeList();
        this.biomeList.setListboxState(listboxState);
        this.listItemSelected(this.biomeList, GuiWorldBiomes.listboxState.selectedElement);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.biomeList.func_178039_p();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 2: {
                    listboxState.resetState();
                    break;
                }
                case 10: {
                    this.biomeList.saveListboxState(listboxState);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiBiomeSettings(this, this.biomeSelected));
                    return;
                }
                case 11: {
                    this.biomeList.saveListboxState(listboxState);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiHabitatMain(this, this.biomeSelected));
                    return;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.biomeList.func_148128_a(mouseX, mouseY, partialTicks);
        int posX = this.getLeftColumnCenterX();
        int posY = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.biome_types", (Object[])new Object[0]), posX, posY, 0x60E060);
        posX = this.getRightColumnCenterX();
        posY = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]), posX, posY, 0x60E060);
        posY = this.getButtonRowStartY(4) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.generation_rates", (Object[])new Object[0]), posX, posY, 0x60E060);
        if (this.biomeSelected != null) {
            this.drawHabitatGraph();
        }
    }

    @Override
    public void listItemSelected(GuiPmpListbox list, int slotIndex) {
        this.biomeSelected = TypeBiome.getBiomeTypeFromName(this.biomeList.getSelectedItemKey());
        this.biomeList.saveListboxState(listboxState);
    }

    @Override
    public void listItemDoubleClicked(GuiPmpListbox list, int slotIndex) {
    }

    @Override
    public int getListboxHeight() {
        return 140;
    }

    private void populateBiomeList() {
        for (TypeBiome biome : TypeBiome.values()) {
            this.biomeList.addListboxEntry(biome.resourceName, biome.getLocalizedNameFormatted());
        }
    }

    private void drawHabitatGraph() {
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.biomeSelected);
        if (dataBiome == null) {
            return;
        }
        int x = this.field_146294_l / 2 + 4;
        int y = this.getButtonRowStartY(7) + 20 - 4;
        for (DefHabitat defHabitat : DefHabitat.values()) {
            if (this.biomeSelected.getHabitats().contains((Object)defHabitat)) {
                int rateTree;
                int ratePlant;
                DataHabitat dataHabitat = dataBiome.habitats.get((Object)defHabitat);
                if (dataHabitat != null) {
                    ratePlant = dataHabitat.worldgenRatePlants / 3;
                    rateTree = dataHabitat.worldgenRateTrees / 3;
                } else {
                    ratePlant = 0;
                    rateTree = 0;
                }
                GuiCore.drawMiniLEDBar(x, y, 33, ratePlant, defHabitat.colorCode);
                x += 4;
                if (defHabitat.canHabitatContainTrees()) {
                    GuiCore.drawMiniLEDBar(x, y, 33, rateTree, '2');
                } else {
                    GuiCore.drawMiniLEDBar(x, y, 33, rateTree, '0');
                }
                x += 5;
                continue;
            }
            GuiCore.drawMiniLEDBar(x, y, 33, 0, '0');
            GuiCore.drawMiniLEDBar(x += 4, y, 33, 0, '0');
            x += 5;
        }
    }
}

