/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.data.DataHabitatPlant;
import pmp.core.def.DefHabitat;
import pmp.core.type.TypeBiome;
import pmp.core.type.TypePlantCat;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiCore;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpSlider;
import pmp.gui.control.GuiPmpSliderMode;

public class GuiPlantSettings
extends GuiScreenBase {
    private final TypeBiome biome;
    private final DefHabitat habitat;
    private DataHabitatPlant dataPlant;
    private GuiPmpSlider spawnWeight;
    private GuiPmpSlider clusterRadius;
    private GuiPmpSlider clusterChance;
    private GuiPmpSlider maxElevRange;
    private final boolean canEditCluster;
    private final boolean canEditElevation;

    public GuiPlantSettings(GuiScreen parentGuiScreen, TypeBiome biome, DefHabitat habitat, DataHabitatPlant dataPlant) {
        super(parentGuiScreen, null, GuiButtonLayout.DEFAULTS_DONE);
        this.biome = biome;
        this.habitat = habitat;
        this.dataPlant = dataPlant;
        this.name = String.format("%s %s %s", I18n.func_135052_a((String)"gui.customize", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.plant", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]));
        TypePlantCat category = dataPlant.getDefPlant().getPlantCategory();
        this.canEditCluster = category.canEditCluster;
        this.canEditElevation = category.canEditElevation;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getCenteredButtonStartX(180);
        int yPos = this.getButtonRowStartY(3);
        this.spawnWeight = new GuiPmpSlider(this, 10, xPos, yPos, 180, 20, I18n.func_135052_a((String)"gui.spawn_weight", (Object[])new Object[0]), 1, 50, 100, 1);
        yPos = this.getButtonRowStartY(4);
        if (this.canEditCluster) {
            this.clusterRadius = new GuiPmpSlider(this, 11, xPos, yPos, 180, 20, I18n.func_135052_a((String)"gui.cluster_radius", (Object[])new Object[0]), 0, 2, 8, 1);
            yPos = this.getButtonRowStartY(5);
            this.clusterChance = new GuiPmpSlider(this, 12, xPos, yPos, 180, 20, I18n.func_135052_a((String)"gui.chance_to_spawn", (Object[])new Object[0]), 1, 50, 100, 1);
            this.clusterChance.setSliderMode(GuiPmpSliderMode.PERCENT);
            yPos = this.getButtonRowStartY(6);
        }
        if (this.canEditElevation) {
            this.maxElevRange = new GuiPmpSlider(this, 13, xPos, yPos, 180, 20, I18n.func_135052_a((String)"gui.max_elev_range", (Object[])new Object[0]), 0, 3, 8, 1);
        }
        this.updateButtonStatesFromSettings();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    this.dataPlant.applyDefaultSettings();
                    this.updateButtonStatesFromSettings();
                    break;
                }
                case 2: {
                    this.updateSettingsFromButtonStates();
                    PlantMegaPack.settings.saveBiomeSettings(this.biome);
                    break;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int posX = this.field_146294_l / 2 - 16;
        int posY = this.getButtonRowStartY(1);
        if (this.dataPlant.getDefPlant() != null) {
            GuiCore.drawPlantTexture(this.dataPlant.getDefPlant(), posX, posY, 32);
        }
    }

    private void updateButtonStatesFromSettings() {
        this.spawnWeight.setIntValue(this.dataPlant.spawnWeight);
        this.spawnWeight.updateDisplayString();
        if (this.canEditCluster) {
            this.clusterRadius.setIntValue(this.dataPlant.clusterRadius);
            this.clusterRadius.updateDisplayString();
            this.clusterChance.setIntValue(this.dataPlant.clusterChance);
            this.clusterChance.updateDisplayString();
        }
        if (this.canEditElevation) {
            this.maxElevRange.setIntValue(this.dataPlant.maxElevRange);
            this.maxElevRange.updateDisplayString();
        }
    }

    private void updateSettingsFromButtonStates() {
        this.dataPlant.spawnWeight = this.spawnWeight.getIntValue();
        if (this.canEditCluster) {
            this.dataPlant.clusterRadius = this.clusterRadius.getIntValue();
            this.dataPlant.clusterChance = this.clusterChance.getIntValue();
        }
        if (this.canEditElevation) {
            this.dataPlant.maxElevRange = this.maxElevRange.getIntValue();
        }
    }
}

