/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import pmp.PlantMegaPack;
import pmp.core.def.DefItem;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiCore;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpSlider;

public class GuiGeneralPowder
extends GuiScreenBase {
    private GuiPmpSlider sliderConditionerRadius;
    private GuiPmpSlider sliderConditionerUses;
    private GuiPmpSlider sliderDefoliantRadius;
    private GuiPmpSlider sliderDefoliantUses;
    private GuiPmpSlider sliderFertilizerRadius;
    private GuiPmpSlider sliderFertilizerUses;
    private final ResourceLocation textureConditioner;
    private final ResourceLocation textureDefoliant;
    private final ResourceLocation textureFertilizer;

    public GuiGeneralPowder(GuiScreen parentGuiScreen) {
        super(parentGuiScreen, "gui.powders", GuiButtonLayout.DEFAULTS_DONE);
        String rootPath = String.format("%s:textures/items/", "pmp");
        this.textureConditioner = new ResourceLocation(String.format("%s%s.png", rootPath, DefItem.PLNTPW_CON.itemName));
        this.textureDefoliant = new ResourceLocation(String.format("%s%s.png", rootPath, DefItem.PLNTPW_DEF.itemName));
        this.textureFertilizer = new ResourceLocation(String.format("%s%s.png", rootPath, DefItem.PLNTPW_FER.itemName));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getLeftColumnStartX() + 4;
        int yPos = this.getButtonRowStartY(2);
        this.sliderConditionerRadius = new GuiPmpSlider(this, 10, xPos, yPos, 150, 20, DefItem.PLNTPW_CON.getLocalizedName(), 2, 3, 6, 1);
        yPos = this.getButtonRowStartY(3);
        this.sliderDefoliantRadius = new GuiPmpSlider(this, 11, xPos, yPos, 150, 20, DefItem.PLNTPW_DEF.getLocalizedName(), 2, 3, 6, 1);
        yPos = this.getButtonRowStartY(4);
        this.sliderFertilizerRadius = new GuiPmpSlider(this, 12, xPos, yPos, 150, 20, DefItem.PLNTPW_FER.getLocalizedName(), 2, 3, 6, 1);
        xPos = this.field_146294_l / 2 + 4;
        yPos = this.getButtonRowStartY(2);
        this.sliderConditionerUses = new GuiPmpSlider(this, 20, xPos, yPos, 150, 20, DefItem.PLNTPW_CON.getLocalizedName(), 10, 20, 50, 1);
        yPos = this.getButtonRowStartY(3);
        this.sliderDefoliantUses = new GuiPmpSlider(this, 21, xPos, yPos, 150, 20, DefItem.PLNTPW_DEF.getLocalizedName(), 10, 20, 50, 1);
        yPos = this.getButtonRowStartY(4);
        this.sliderFertilizerUses = new GuiPmpSlider(this, 22, xPos, yPos, 150, 20, DefItem.PLNTPW_FER.getLocalizedName(), 10, 20, 50, 1);
        this.updateButtonStatesFromSettings();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    PlantMegaPack.settings.resetPowderDefaults();
                    this.updateButtonStatesFromSettings();
                    break;
                }
                case 2: {
                    this.updateSettingsFromButtonStates();
                    PlantMegaPack.settings.saveSettings();
                    break;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int xPos = this.getLeftColumnCenterX();
        int yPos = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.radius", (Object[])new Object[0]), xPos, yPos, 0x60E060);
        xPos = this.getRightColumnCenterX();
        yPos = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.uses", (Object[])new Object[0]), xPos, yPos, 0x60E060);
        xPos = this.getLeftColumnStartX() - 20;
        yPos = this.getButtonRowStartY(2);
        GuiCore.drawTexture(this.textureConditioner, xPos, yPos, 20, 20);
        yPos = this.getButtonRowStartY(3);
        GuiCore.drawTexture(this.textureDefoliant, xPos, yPos, 20, 20);
        yPos = this.getButtonRowStartY(4);
        GuiCore.drawTexture(this.textureFertilizer, xPos, yPos, 20, 20);
    }

    private void updateButtonStatesFromSettings() {
        this.sliderConditionerRadius.setIntValue(PlantMegaPack.settings.powderConditionerRadius);
        this.sliderConditionerRadius.updateDisplayString();
        this.sliderConditionerUses.setIntValue(PlantMegaPack.settings.powderConditionerUses);
        this.sliderConditionerUses.updateDisplayString();
        this.sliderDefoliantRadius.setIntValue(PlantMegaPack.settings.powderDefoliantRadius);
        this.sliderDefoliantRadius.updateDisplayString();
        this.sliderDefoliantUses.setIntValue(PlantMegaPack.settings.powderDefoliantUses);
        this.sliderDefoliantUses.updateDisplayString();
        this.sliderFertilizerRadius.setIntValue(PlantMegaPack.settings.powderFertilizerRadius);
        this.sliderFertilizerRadius.updateDisplayString();
        this.sliderFertilizerUses.setIntValue(PlantMegaPack.settings.powderFertilizerUses);
        this.sliderFertilizerUses.updateDisplayString();
    }

    private void updateSettingsFromButtonStates() {
        PlantMegaPack.settings.powderConditionerRadius = this.sliderConditionerRadius.getIntValue();
        PlantMegaPack.settings.powderConditionerUses = this.sliderConditionerUses.getIntValue();
        PlantMegaPack.settings.powderDefoliantRadius = this.sliderDefoliantRadius.getIntValue();
        PlantMegaPack.settings.powderDefoliantUses = this.sliderDefoliantUses.getIntValue();
        PlantMegaPack.settings.powderFertilizerRadius = this.sliderFertilizerRadius.getIntValue();
        PlantMegaPack.settings.powderFertilizerUses = this.sliderFertilizerUses.getIntValue();
    }
}

