/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.control;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import pmp.gui.control.GuiPmpListboxEntry;
import pmp.gui.control.GuiPmpListboxState;
import pmp.gui.control.IListboxOwner;

@SideOnly(value=Side.CLIENT)
public class GuiPmpListbox
extends GuiListExtended {
    private static final ResourceLocation LIST_BACKGROUND = new ResourceLocation(String.format("%s:textures/gui/list_background.png", "pmp"));
    private IListboxOwner parent;
    private List<GuiPmpListboxEntry> listEntries = Lists.newArrayList();
    public boolean field_178041_q;
    private boolean drawCustom;

    public GuiPmpListbox(IListboxOwner parent, int xPos, int yPos, int width, int height, int slotHeight) {
        super(Minecraft.func_71410_x(), width, parent.getHeight(), yPos, height, slotHeight);
        this.parent = parent;
        this.field_178041_q = true;
        this.drawCustom = false;
        this.field_148152_e = xPos;
        this.field_148151_d = xPos + width;
        this.field_148154_c = yPos + height;
        this.func_148133_a(false, 0);
        this.field_148166_t = true;
        this.func_148143_b(true);
        this.func_148134_d(7, 8);
    }

    public void addListboxEntry(String key, String localizedName) {
        this.listEntries.add(new GuiPmpListboxEntry(key, localizedName));
    }

    public boolean getCustomDrawMode() {
        return this.drawCustom;
    }

    public void setCustomDrawMode(boolean customDraw) {
        this.drawCustom = customDraw;
    }

    public void scrollToAndSelectEntry(int slotID) {
        this.selectListItem(slotID);
        this.field_148169_q = slotID * this.field_148149_f + this.field_148158_l / this.field_148149_f - 4 - this.field_148149_f;
        this.func_148121_k();
    }

    public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.field_178041_q) {
            this.drawScreenCustom(mouseXIn, mouseYIn, partialTicks);
        }
    }

    private void drawScreenCustom(int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.field_178041_q) {
            this.field_148150_g = mouseXIn;
            this.field_148162_h = mouseYIn;
            this.func_148123_a();
            int i = this.func_148137_d();
            int j = i + 6;
            this.func_148121_k();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            this.drawContainerBackground(tessellator);
            int k = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int l = this.field_148153_b + 4 - (int)this.field_148169_q;
            this.func_192638_a(k, l, mouseXIn, mouseYIn, partialTicks);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)0, (int)1);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            int j1 = this.func_148135_f();
            if (j1 > 0) {
                int k1 = (this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b) / this.func_148138_e();
                int l1 = (int)this.field_148169_q * (this.field_148154_c - this.field_148153_b - (k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8)))) / j1 + this.field_148153_b;
                if (l1 < this.field_148153_b) {
                    l1 = this.field_148153_b;
                }
                int color = this.drawCustom ? 9729114 : 0;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldrenderer.func_181662_b((double)i, (double)this.field_148154_c, 0.0).func_187315_a(0.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)j, (double)this.field_148154_c, 0.0).func_187315_a(1.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)j, (double)this.field_148153_b, 0.0).func_187315_a(1.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)i, (double)this.field_148153_b, 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                tessellator.func_78381_a();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldrenderer.func_181662_b((double)i, (double)(l1 + k1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)j, (double)(l1 + k1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)j, (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)i, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                tessellator.func_78381_a();
                color = this.drawCustom ? 13746081 : 0x606060;
                r = color >> 16 & 0xFF;
                g = color >> 8 & 0xFF;
                b = color & 0xFF;
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldrenderer.func_181662_b((double)i, (double)(l1 + k1 - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)(j - 1), (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)i, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.func_148142_b(mouseXIn, mouseYIn);
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }
    }

    protected void drawContainerBackground(Tessellator tessellator) {
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        this.field_148161_k.func_110434_K().func_110577_a(this.drawCustom ? LIST_BACKGROUND : Gui.field_110325_k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        int color = this.drawCustom ? 0xFFFFFF : 0;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b((double)this.field_148152_e, (double)this.field_148154_c, 0.0).func_187315_a((double)((float)this.field_148152_e / f), (double)((float)(this.field_148154_c + (int)this.field_148169_q) / f)).func_181669_b(r, g, b, 255).func_181675_d();
        worldrenderer.func_181662_b((double)this.field_148151_d, (double)this.field_148154_c, 0.0).func_187315_a((double)((float)this.field_148151_d / f), (double)((float)(this.field_148154_c + (int)this.field_148169_q) / f)).func_181669_b(r, g, b, 255).func_181675_d();
        worldrenderer.func_181662_b((double)this.field_148151_d, (double)this.field_148153_b, 0.0).func_187315_a((double)((float)this.field_148151_d / f), (double)((float)(this.field_148153_b + (int)this.field_148169_q) / f)).func_181669_b(r, g, b, 255).func_181675_d();
        worldrenderer.func_181662_b((double)this.field_148152_e, (double)this.field_148153_b, 0.0).func_187315_a((double)((float)this.field_148152_e / f), (double)((float)(this.field_148153_b + (int)this.field_148169_q) / f)).func_181669_b(r, g, b, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void func_192638_a(int par1, int par2, int mouseXIn, int mouseYIn, float partialTicks) {
        int i = this.func_148127_b();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        for (int j = 0; j < i; ++j) {
            int k = par2 + j * this.field_148149_f + this.field_148160_j;
            int l = this.field_148149_f - 4;
            if (k > this.field_148154_c || k + l < this.field_148153_b) {
                this.func_192639_a(j, par1, k, partialTicks);
            }
            if (this.field_148166_t && this.func_148131_a(j) && k > this.field_148153_b + 2 && k < this.field_148154_c - 8) {
                int i1 = this.field_148152_e + (this.field_148155_a / 2 - this.func_148139_c() / 2);
                int j1 = this.field_148152_e + this.field_148155_a / 2 + this.func_148139_c() / 2;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                int color = this.func_148125_i() ? (this.drawCustom ? 12165763 : 0xFFFF80) : 0x404040;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                worldrenderer.func_181662_b((double)i1, (double)(k + l + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)j1, (double)(k + l + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)j1, (double)(k - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)i1, (double)(k - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                color = this.func_148125_i() ? (this.drawCustom ? 13746081 : 7686922) : 0x404040;
                r = color >> 16 & 0xFF;
                g = color >> 8 & 0xFF;
                b = color & 0xFF;
                worldrenderer.func_181662_b((double)(i1 + 1), (double)(k + l + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)(j1 - 1), (double)(k + l + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)(j1 - 1), (double)(k - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                worldrenderer.func_181662_b((double)(i1 + 1), (double)(k - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.func_192637_a(j, par1, k, l, mouseXIn, mouseYIn, partialTicks);
        }
    }

    protected void func_192637_a(int entryID, int x, int y, int slotHeight, int mouseX, int mouseY, float partialTicks) {
        if (y > this.field_148153_b + 2 && y < this.field_148154_c - 8) {
            this.getListEntry(entryID).func_192634_a(entryID, x, y, this.func_148139_c(), slotHeight, mouseX, mouseY, this.func_148124_c(mouseX, mouseY) == entryID, partialTicks);
        }
    }

    protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        if (this.func_148125_i()) {
            super.func_148144_a(slotIndex, isDoubleClick, mouseX, mouseY);
            this.field_148168_r = slotIndex;
            if (this.parent != null) {
                if (isDoubleClick) {
                    this.parent.listItemDoubleClicked(this, slotIndex);
                } else {
                    this.parent.listItemSelected(this, slotIndex);
                }
            }
        }
    }

    public GuiPmpListboxEntry getListEntry(int slotIndex) {
        return this.listEntries.get(slotIndex);
    }

    public int func_148139_c() {
        return this.field_148155_a;
    }

    protected int func_148137_d() {
        return this.field_148151_d - 6;
    }

    public int func_148127_b() {
        return this.listEntries.size();
    }

    public void func_178039_p() {
        if (this.func_148141_e(this.field_148162_h) && this.func_148125_i()) {
            if (Mouse.isButtonDown((int)0)) {
                if ((float)this.field_148157_o == -1.0f) {
                    boolean flag = true;
                    if (this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c) {
                        int i = this.field_148152_e + 4;
                        int j = this.func_148137_d() - 1;
                        int k = this.field_148162_h - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
                        int l = k / this.field_148149_f;
                        if (this.field_148150_g >= i && this.field_148150_g <= j && l >= 0 && k >= 0 && l < this.func_148127_b()) {
                            boolean flag1 = l == this.field_148168_r && Minecraft.func_71386_F() - this.field_148167_s < 250L;
                            this.func_148144_a(l, flag1, this.field_148150_g, this.field_148162_h);
                            this.field_148168_r = l;
                            this.field_148167_s = Minecraft.func_71386_F();
                        } else if (this.field_148150_g >= i && this.field_148150_g <= j && k < 0) {
                            this.func_148132_a(this.field_148150_g - i, this.field_148162_h - this.field_148153_b + (int)this.field_148169_q - 4);
                            flag = false;
                        }
                        int i2 = this.func_148137_d();
                        int i1 = this.field_148151_d;
                        if (this.field_148150_g >= i2 && this.field_148150_g <= i1) {
                            this.field_148170_p = -1.0f;
                            int j1 = this.func_148135_f();
                            if (j1 < 1) {
                                j1 = 1;
                            }
                            int k1 = (int)((float)((this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b)) / (float)this.func_148138_e());
                            k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8));
                            this.field_148170_p /= (float)(this.field_148154_c - this.field_148153_b - k1) / (float)j1;
                        } else {
                            this.field_148170_p = 1.0f;
                        }
                        this.field_148157_o = flag ? this.field_148162_h : -2;
                    } else {
                        this.field_148157_o = -2;
                    }
                } else if ((float)this.field_148157_o >= 0.0f) {
                    this.field_148169_q -= ((float)this.field_148162_h - (float)this.field_148157_o) * this.field_148170_p;
                    this.field_148157_o = this.field_148162_h;
                }
            } else {
                this.field_148157_o = -1;
            }
            int l1 = Mouse.getEventDWheel();
            if (l1 != 0) {
                if (l1 > 0) {
                    l1 = -1;
                } else if (l1 < 0) {
                    l1 = 1;
                }
                this.field_148169_q += (float)(l1 * this.field_148149_f);
            }
        }
    }

    protected boolean func_148131_a(int slotIndex) {
        return this.field_148168_r == slotIndex;
    }

    public int getSelectedItemIndex() {
        return this.field_148168_r;
    }

    public String getSelectedItemKey() {
        if (this.field_148168_r >= 0 && !this.listEntries.isEmpty()) {
            if (this.field_148168_r > this.listEntries.size() - 1) {
                this.field_148168_r = 0;
            }
            return this.listEntries.get((int)this.field_148168_r).key;
        }
        return "";
    }

    public String getSelectedItemText() {
        if (this.field_148168_r >= 0 && !this.listEntries.isEmpty()) {
            return this.listEntries.get((int)this.field_148168_r).localizedName;
        }
        return "";
    }

    public void selectListItem(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.listEntries.size()) {
            return;
        }
        this.field_148168_r = slotIndex;
    }

    public void saveListboxState(GuiPmpListboxState state) {
        state.amountScrolled = this.field_148169_q;
        state.scrollMultiplier = this.field_148170_p;
        state.selectedElement = this.field_148168_r;
    }

    public void setListboxState(GuiPmpListboxState state) {
        this.field_148169_q = state.amountScrolled;
        this.field_148170_p = state.scrollMultiplier;
        this.field_148168_r = state.selectedElement;
    }

    public void clearAllEntries() {
        this.listEntries.clear();
        this.field_148168_r = 0;
    }

    public List<GuiPmpListboxEntry> getListEntries() {
        return this.listEntries;
    }

    public int getSlotFromKey(String key) {
        int size = this.listEntries.size();
        for (int i = 0; i < size; ++i) {
            if (!this.listEntries.get((int)i).key.matches(key)) continue;
            return i;
        }
        return -1;
    }
}

