/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiContainerBase
extends GuiContainer {
    protected World world;
    protected EntityPlayer player;
    protected BlockPos pos;
    protected String containerID;
    protected int invLabelY;
    protected ResourceLocation backgroundTexture = null;

    public GuiContainerBase(Container container, World world, EntityPlayer player, BlockPos pos) {
        super(container);
        this.world = world;
        this.player = player;
        this.pos = pos;
    }

    protected void init(String containerID, int width, int height, int invLabelY) {
        this.containerID = containerID;
        this.backgroundTexture = new ResourceLocation("pmp", String.format("textures/gui/cont/%s.png", this.containerID));
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.invLabelY = invLabelY;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)String.format("cont.%s", this.containerID), (Object[])new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.inventory", (Object[])new Object[0]), 8, this.invLabelY, 0x404040);
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.backgroundTexture != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(this.backgroundTexture);
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
    }
}

