/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.type;

import net.minecraft.client.resources.I18n;
import pmp.core.def.DefItem;

public enum TypePlantRoot {
    FIRER(0, "firer", 'c', DefItem.ROOT_FIRER),
    HEALT(1, "healt", 'a', DefItem.ROOT_HEALT),
    NTVIS(2, "ntvis", '9', DefItem.ROOT_NTVIS),
    POISO(3, "poiso", 'e', DefItem.ROOT_POISO),
    STREN(4, "stren", '6', DefItem.ROOT_STREN),
    SWIFT(5, "swift", 'd', DefItem.ROOT_SWIFT),
    WATBR(6, "watbr", 'b', DefItem.ROOT_WATBR),
    INVIS(7, "invis", '3', DefItem.ROOT_INVIS),
    LEAPI(8, "leapi", 'a', DefItem.ROOT_LEAPI);

    public static final TypePlantRoot[] ID_LOOKUP;
    public final int ID;
    public final String itemName;
    public final char formatCode;
    public final DefItem rootItem;

    private TypePlantRoot(int ID, String itemName, char formatCode, DefItem rootItem) {
        this.ID = ID;
        this.itemName = itemName;
        this.formatCode = formatCode;
        this.rootItem = rootItem;
    }

    public String getUnlocalizedName() {
        return String.format("item.root_%s.name", this.itemName);
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public String getLocalizedNameFormatted() {
        return String.format("\u00a7%s%s\u00a7r", Character.valueOf(this.formatCode), this.getLocalizedName());
    }

    public DefItem getRootItem() {
        return this.rootItem;
    }

    public static DefItem getRootItemFromID(int ID) {
        return TypePlantRoot.getRootFromID(ID).getRootItem();
    }

    public static TypePlantRoot getRootFromID(int ID) {
        if (ID < 0 || ID >= ID_LOOKUP.length) {
            ID = 0;
        }
        return ID_LOOKUP[ID];
    }

    static {
        ID_LOOKUP = new TypePlantRoot[TypePlantRoot.values().length];
        TypePlantRoot[] typePlantRootArray = TypePlantRoot.values();
        int n = typePlantRootArray.length;
        for (int i = 0; i < n; ++i) {
            TypePlantRoot variant$enumtype;
            TypePlantRoot.ID_LOOKUP[variant$enumtype.ID] = variant$enumtype = typePlantRootArray[i];
        }
    }
}

