/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.type;

import java.util.EnumSet;
import net.minecraft.client.resources.I18n;
import pmp.core.def.DefBiomeHabitats;
import pmp.core.def.DefHabitat;

public enum TypePlantCat {
    BAMB("bamb", "bamboo", '2', 10, true, true, DefBiomeHabitats.LAND_NO_SHADE.habitats),
    BEACH("beach", "plant", 'e', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    BBUSH("bbush", "plant", 'a', 10, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    CACTU("cactu", "plant", '2', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    CLIMB("climb", "plant", '6', 50, false, false, EnumSet.of(DefHabitat.LAND_BIOME_EDGE_SLOPE, DefHabitat.LAND_SLOPE, DefHabitat.LAND_SLOPE_SHADE)),
    CROPA("cropa", "plant", 'b', 10, true, false, EnumSet.of(DefHabitat.FRESHWATER_MARGIN)),
    CROPL("cropl", "plant", '6', -1, false, false, EnumSet.noneOf(DefHabitat.class)),
    DESER("deser", "plant", 'e', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    EPIPH("epiph", "plant", '5', 50, false, false, EnumSet.of(DefHabitat.TREE_EPIPHYTE)),
    FLOAT("float", "plant", 'b', 50, true, false, EnumSet.of(DefHabitat.FRESHWATER_FLOATING, DefHabitat.MARINE_FLOATING)),
    FLOWR("flowr", "plant", 'c', 10, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    FOREC("forec", "plant", '2', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    FOREW("forew", "plant", '2', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    FRESH("fresh", "plant", 'b', 50, true, true, EnumSet.of(DefHabitat.FRESHWATER_DEEP, DefHabitat.MARINE_DEEP)),
    FUNGU("fungu", "plant", '6', 50, true, true, DefBiomeHabitats.LAND_SHADE.habitats),
    GRNDC("grndc", "plant", '2', 10, true, true, EnumSet.of(DefHabitat.LAND_BIOME_EDGE, new DefHabitat[]{DefHabitat.LAND_BIOME_EDGE_SLOPE, DefHabitat.LAND_OPEN, DefHabitat.LAND_SHADE, DefHabitat.LAND_SLOPE, DefHabitat.LAND_SLOPE_SHADE, DefHabitat.LAND_WATER_EDGE, DefHabitat.LAND_WATER_EDGE_SHADE, DefHabitat.LAND_TREE_BASE})),
    HANGP("hangp", "hanging", '2', -1, false, false, EnumSet.noneOf(DefHabitat.class)),
    IMMER("immer", "plant", 'd', 50, true, false, EnumSet.of(DefHabitat.FRESHWATER_MARGIN, DefHabitat.MARINE_MARGIN)),
    JUNGL("jungl", "plant", '2', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    LARGE("large", "plant", 'e', 10, true, true, DefBiomeHabitats.LAND_NO_SHADE.habitats),
    LEAVE("leave", "plant", '2', -1, false, false, EnumSet.noneOf(DefHabitat.class)),
    MEDIU("mediu", "plant", 'e', 10, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    MESA("mesa", "plant", '4', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    MOUNT("mount", "plant", 'd', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    PLAIN("plain", "plant", 'a', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    SALTW("saltw", "plant", '9', 50, true, true, EnumSet.of(DefHabitat.FRESHWATER_DEEP, DefHabitat.MARINE_DEEP)),
    SAPLI("sapli", "plant", '2', -1, false, false, EnumSet.noneOf(DefHabitat.class)),
    SAVAN("savan", "plant", 'e', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats),
    VINE("vine", "vine", 'a', 50, false, false, EnumSet.of(DefHabitat.TREE_VINE)),
    WETLA("wetla", "plant", '3', 50, true, true, DefBiomeHabitats.LAND_ALL.habitats);

    private final String name;
    private final String oreDictPrefix;
    public final char colorCode;
    public final int defaultSpawnWeight;
    public final boolean canEditCluster;
    public final boolean canEditElevation;
    public final EnumSet<DefHabitat> habitats;

    private TypePlantCat(String name, String oreDictPrefix, char colorCode, int defaultSpawnWeight, boolean canEditCluster, boolean canEditElevation, EnumSet<DefHabitat> habitats) {
        this.name = name;
        this.oreDictPrefix = oreDictPrefix;
        this.colorCode = colorCode;
        this.defaultSpawnWeight = defaultSpawnWeight;
        this.canEditCluster = canEditCluster;
        this.canEditElevation = canEditElevation;
        this.habitats = habitats;
    }

    public String getName() {
        return this.name;
    }

    public String getOreDictPrefix() {
        return this.oreDictPrefix;
    }

    public String getFormattedName() {
        return String.format("\u00a7%s%s\u00a7r", Character.valueOf(this.colorCode), I18n.func_135052_a((String)String.format("plcat.%s", this.name), (Object[])new Object[0]));
    }

    public boolean isLandPlant() {
        return this != CLIMB && this != CROPA && this != CROPL && this != EPIPH && this != FLOAT && this != FRESH && this != GRNDC && this != HANGP && this != IMMER && this != LEAVE && this != SALTW && this != SAPLI && this != VINE;
    }
}

