/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.def;

import net.minecraft.client.resources.I18n;
import pmp.core.type.TypeTileEntity;

public enum DefWorkbench {
    POTTING_TABLE("wkben_pottb", "PottingTable", TypeTileEntity.POTTING_TABLE);

    private final String blockName;
    public final String oreDictName;
    public final TypeTileEntity typeTileEntity;

    private DefWorkbench(String blockName, String oreDictName, TypeTileEntity typeTileEntity) {
        this.blockName = blockName;
        this.oreDictName = String.format("workbench%s", oreDictName);
        this.typeTileEntity = typeTileEntity;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public String getUnlocalizedName() {
        return String.format("tile.%s.name", this.blockName);
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public static DefWorkbench getWorkbenchFromName(String blockName) {
        for (DefWorkbench type : DefWorkbench.values()) {
            if (!blockName.matches(type.blockName)) continue;
            return type;
        }
        return null;
    }

    public String getJson() {
        return String.format("{\"item\":\"%s:%s\"}", "pmp", this.getBlockName());
    }

    public String getJson(int count) {
        return String.format("{\"item\":\"%s:%s\",\"count\":%d}", "pmp", this.getBlockName(), count);
    }
}

