/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.def;

import net.minecraft.client.resources.I18n;
import pmp.core.def.DefFood;
import pmp.core.type.TypeTreeFruit;
import pmp.worldgen.tree.GenAcaciBaobo;
import pmp.worldgen.tree.GenAcaciCucum;
import pmp.worldgen.tree.GenAcaciRivbu;
import pmp.worldgen.tree.GenAcaciWhist;
import pmp.worldgen.tree.GenBirchChdwa;
import pmp.worldgen.tree.GenBirchSilve;
import pmp.worldgen.tree.GenBirchWater;
import pmp.worldgen.tree.GenBirchWhite;
import pmp.worldgen.tree.GenDkoakBur;
import pmp.worldgen.tree.GenDkoakEverg;
import pmp.worldgen.tree.GenDkoakItali;
import pmp.worldgen.tree.GenDkoakSessi;
import pmp.worldgen.tree.GenJunglAcai;
import pmp.worldgen.tree.GenJunglBanan;
import pmp.worldgen.tree.GenJunglBombo;
import pmp.worldgen.tree.GenJunglCocon;
import pmp.worldgen.tree.GenNutAlmon;
import pmp.worldgen.tree.GenNutBrazi;
import pmp.worldgen.tree.GenNutButte;
import pmp.worldgen.tree.GenNutCandl;
import pmp.worldgen.tree.GenNutCashe;
import pmp.worldgen.tree.GenNutGabon;
import pmp.worldgen.tree.GenNutHazel;
import pmp.worldgen.tree.GenNutMacad;
import pmp.worldgen.tree.GenNutMaya;
import pmp.worldgen.tree.GenNutPecan;
import pmp.worldgen.tree.GenNutPista;
import pmp.worldgen.tree.GenNutWalnu;
import pmp.worldgen.tree.GenOakBlue;
import pmp.worldgen.tree.GenOakEngli;
import pmp.worldgen.tree.GenOakGray;
import pmp.worldgen.tree.GenOakJapem;
import pmp.worldgen.tree.GenSprucBlack;
import pmp.worldgen.tree.GenSprucMarti;
import pmp.worldgen.tree.GenSprucNorwa;
import pmp.worldgen.tree.GenSprucRed;
import pmp.worldgen.tree.GenTreeBase;
import pmp.worldgen.tree.GenTreeBaseFruit;

public enum DefTree {
    ACACI_BAOBO("acaci_baobo", 7910174, null, null, true, GenAcaciBaobo.class),
    ACACI_CUCUM("acaci_cucum", 7910174, null, null, true, GenAcaciCucum.class),
    ACACI_RIVBU("acaci_rivbu", 7910174, null, null, true, GenAcaciRivbu.class),
    ACACI_WHIST("acaci_whist", 7910174, null, null, true, GenAcaciWhist.class),
    BIRCH_CHDWA("birch_chdwa", 6982471, null, null, false, GenBirchChdwa.class),
    BIRCH_SILVE("birch_silve", 9669958, null, null, false, GenBirchSilve.class),
    BIRCH_WATER("birch_water", 9669958, null, null, false, GenBirchWater.class),
    BIRCH_WHTGR("birch_whtgr", 9024886, null, null, false, GenBirchWhite.class),
    BIRCH_WHTYE("birch_whtye", 15260291, null, null, false, GenBirchWhite.class),
    BIRCH_WHTOR("birch_whtor", 14917984, null, null, false, GenBirchWhite.class),
    BIRCH_WHTRE("birch_whtre", 15826796, null, null, false, GenBirchWhite.class),
    DKOAK_BUR("dkoak_bur", 4764952, null, null, false, GenDkoakBur.class),
    DKOAK_EVERG("dkoak_everg", 4764952, null, null, false, GenDkoakEverg.class),
    DKOAK_ITALI("dkoak_itali", 4764952, null, null, false, GenDkoakItali.class),
    DKOAK_SESSI("dkoak_sessi", 4764952, null, null, false, GenDkoakSessi.class),
    JUNGL_ACAI("jungl_acai", 4764952, DefFood.BERRY_ACAI, TypeTreeFruit.BERRY, true, GenJunglAcai.class),
    JUNGL_BANAN("jungl_banan", 4764952, DefFood.FRUIT_BANAN, TypeTreeFruit.BANANA, true, GenJunglBanan.class),
    JUNGL_BOMBO("jungl_bombo", 3044111, null, null, true, GenJunglBombo.class),
    JUNGL_COCON("jungl_cocon", 4764952, DefFood.FRUIT_COCON, TypeTreeFruit.ROUND_LARGE, true, GenJunglCocon.class),
    OAK_BLUE("oak_blue", 4765022, null, null, false, GenOakBlue.class),
    OAK_ENGLI("oak_engli", 4764952, null, null, false, GenOakEngli.class),
    OAK_GRAY("oak_gray", 4765022, null, null, false, GenOakGray.class),
    OAK_JAPEM("oak_japem", 11147064, null, null, false, GenOakJapem.class),
    SPRUC_BLACK("spruc_black", 5341265, null, null, false, GenSprucBlack.class),
    SPRUC_MARTI("spruc_marti", 6390372, null, null, false, GenSprucMarti.class),
    SPRUC_NORWA("spruc_norwa", 6525775, null, null, false, GenSprucNorwa.class),
    SPRUC_RED("spruc_red", 6527311, null, null, false, GenSprucRed.class),
    FRUIT_APRIC("fruit_apric", 4764952, DefFood.FRUIT_APRIC, TypeTreeFruit.ROUND_SMALL, false, GenTreeBaseFruit.class),
    FRUIT_AVOCA("fruit_avoca", 3970580, DefFood.FRUIT_AVOCA, TypeTreeFruit.OVAL, false, GenTreeBaseFruit.class),
    FRUIT_CHERR("fruit_cherr", 14498645, DefFood.FRUIT_CHERR, TypeTreeFruit.BERRY, false, GenTreeBaseFruit.class),
    FRUIT_GRAPF("fruit_grapf", 3970580, DefFood.FRUIT_GRAPF, TypeTreeFruit.ROUND_LARGE, false, GenTreeBaseFruit.class),
    FRUIT_GRNAP("fruit_grnap", 4764952, DefFood.FRUIT_GRNAP, TypeTreeFruit.ROUND_SMALL, false, GenTreeBaseFruit.class),
    FRUIT_LEMON("fruit_lemon", 4825365, DefFood.FRUIT_LEMON, TypeTreeFruit.ROUND_SMALL, false, GenTreeBaseFruit.class),
    FRUIT_LIME("fruit_lime", 4109592, DefFood.FRUIT_LIME, TypeTreeFruit.ROUND_SMALL, false, GenTreeBaseFruit.class),
    FRUIT_MANGO("fruit_mango", 4764952, DefFood.FRUIT_MANGO, TypeTreeFruit.ROUND_LARGE, false, GenTreeBaseFruit.class),
    FRUIT_MULBE("fruit_mulbe", 4764952, DefFood.BERRY_MULBE, TypeTreeFruit.BERRY, false, GenTreeBaseFruit.class),
    FRUIT_OLIVE("fruit_olive", 4109592, DefFood.FRUIT_OLIVE, TypeTreeFruit.BERRY, false, GenTreeBaseFruit.class),
    FRUIT_ORANG("fruit_orang", 4764952, DefFood.FRUIT_ORANG, TypeTreeFruit.ROUND_SMALL, false, GenTreeBaseFruit.class),
    FRUIT_PEACH("fruit_peach", 4764952, DefFood.FRUIT_PEACH, TypeTreeFruit.ROUND_SMALL, false, GenTreeBaseFruit.class),
    FRUIT_PEAR("fruit_pear", 4764952, DefFood.FRUIT_PEAR, TypeTreeFruit.OVAL, false, GenTreeBaseFruit.class),
    FRUIT_PLUM("fruit_plum", 14515615, DefFood.FRUIT_PLUM, TypeTreeFruit.ROUND_SMALL, false, GenTreeBaseFruit.class),
    FRUIT_TANGE("fruit_tange", 5420312, DefFood.FRUIT_TANGE, TypeTreeFruit.ROUND_LARGE, false, GenTreeBaseFruit.class),
    FRUIT_YELAP("fruit_yelap", 5420312, DefFood.FRUIT_YELAP, TypeTreeFruit.ROUND_SMALL, false, GenTreeBaseFruit.class),
    NUT_ALMON("nut_almon", 15500934, DefFood.NUT_ALMON, TypeTreeFruit.BERRY, false, GenNutAlmon.class),
    NUT_BRAZI("nut_brazi", 4764952, DefFood.NUT_BRAZI, TypeTreeFruit.BERRY, false, GenNutBrazi.class),
    NUT_BUTTE("nut_butte", 3706387, DefFood.NUT_BUTTE, TypeTreeFruit.BERRY, false, GenNutButte.class),
    NUT_CANDL("nut_candl", 4751948, DefFood.NUT_CANDL, TypeTreeFruit.BERRY, false, GenNutCandl.class),
    NUT_CASHE("nut_cashe", 4764952, DefFood.NUT_CASHE, TypeTreeFruit.BERRY, false, GenNutCashe.class),
    NUT_GABON("nut_gabon", 8434968, DefFood.NUT_GABON, TypeTreeFruit.BERRY, false, GenNutGabon.class),
    NUT_HAZEL("nut_hazel", 4764952, DefFood.NUT_HAZEL, TypeTreeFruit.BERRY, false, GenNutHazel.class),
    NUT_MACAD("nut_macad", 6734142, DefFood.NUT_MACAD, TypeTreeFruit.BERRY, false, GenNutMacad.class),
    NUT_MAYA("nut_maya", 4764952, DefFood.NUT_MAYA, TypeTreeFruit.BERRY, false, GenNutMaya.class),
    NUT_PECAN("nut_pecan", 4764952, DefFood.NUT_PECAN, TypeTreeFruit.BERRY, false, GenNutPecan.class),
    NUT_PISTA("nut_pista", 6789396, DefFood.NUT_PISTA, TypeTreeFruit.BERRY, false, GenNutPista.class),
    NUT_WALNU("nut_walnu", 16050042, DefFood.NUT_WALNU, TypeTreeFruit.BERRY, false, GenNutWalnu.class);

    public final String blockName;
    public final int foliageColor;
    public final DefFood food;
    public final TypeTreeFruit type;
    public final boolean canGrowOnSand;
    public final Class<? extends GenTreeBase> genTreeClass;

    private DefTree(String blockName, int foliageColor, DefFood food, TypeTreeFruit type, boolean canSpawnOnSand, Class<? extends GenTreeBase> genTreeClass) {
        this.blockName = blockName;
        this.foliageColor = foliageColor;
        this.food = food;
        this.type = type;
        this.canGrowOnSand = canSpawnOnSand;
        this.genTreeClass = genTreeClass;
    }

    public String getBlockName() {
        return String.format("sapli_%s", this.blockName);
    }

    public String getLocalizedTreeName() {
        return I18n.func_135052_a((String)String.format("tile.%s.name", this.getBlockName()), (Object[])new Object[0]);
    }

    public String getLocalizedSaplingName() {
        return I18n.func_135052_a((String)String.format("tile.%s.name", this.getBlockName()), (Object[])new Object[0]);
    }

    public String getTreeFruitName() {
        return String.format("trfrt_%s", this.blockName);
    }

    public static DefTree getTreeFromName(String name) {
        for (DefTree defTree : DefTree.values()) {
            if (!name.equals(defTree.blockName)) continue;
            return defTree;
        }
        return null;
    }

    public static DefTree getTreeDefFromFood(DefFood food) {
        for (DefTree defTree : DefTree.values()) {
            if (defTree.food != food) continue;
            return defTree;
        }
        return null;
    }

    public boolean hasFruit() {
        return this.food != null;
    }
}

