/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.def;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import pmp.item.ItemBaseItem;
import pmp.item.ItemBasePowder;

public enum DefItem {
    ROOT_FIRER("root_firer", "rootFireResistance"),
    ROOT_HEALT("root_healt", "rootHealth"),
    ROOT_INVIS("root_invis", "rootInvisibility"),
    ROOT_LEAPI("root_leapi", "rootLeaping"),
    ROOT_NTVIS("root_ntvis", "rootNightVision"),
    ROOT_POISO("root_poiso", "rootPoison"),
    ROOT_STREN("root_stren", "rootStrength"),
    ROOT_SWIFT("root_swift", "rootSwiftness"),
    ROOT_WATBR("root_watbr", "rootWaterBreathing"),
    STEM_CACTU("stem_cactu", "stemCactus"),
    STEM_HARD("stem_hard", "stemHard"),
    STEM_SOFT("stem_soft", "stemSoft"),
    CTAIL_SPIKE("ctail_spike", "cattailSpike"),
    FLOWER_RED("flower_red", "flowerRed"),
    FLOWER_ORA("flower_ora", "flowerOrange"),
    FLOWER_YEL("flower_yel", "flowerYellow"),
    FLOWER_GRN("flower_grn", "flowerGreen"),
    FLOWER_CYA("flower_cya", "flowerCyan"),
    FLOWER_BLU("flower_blu", "flowerBlue"),
    FLOWER_PUR("flower_pur", "flowerPurple"),
    FLOWER_PNK("flower_pnk", "flowerPink"),
    FLOWER_WHT("flower_wht", "flowerWhite"),
    PLNTPW_CON("plntpw_con", "powderConditioner", ItemBasePowder.class),
    PLNTPW_DEF("plntpw_def", "powderDefoliant", ItemBasePowder.class),
    PLNTPW_FER("plntpw_fer", "powderFertilizer", ItemBasePowder.class);

    public final String itemName;
    public final String oreDictName;
    public final Class<? extends Item> itemClass;

    private DefItem(String itemName, String oreDictName) {
        this(itemName, oreDictName, ItemBaseItem.class);
    }

    private DefItem(String itemName, String oreDictName, Class<? extends Item> itemClass) {
        this.itemName = itemName;
        this.oreDictName = oreDictName;
        this.itemClass = itemClass;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getUnlocalizedName() {
        return String.format("item.%s.name", this.itemName);
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public static DefItem getFlowerFromID(int ID) {
        if (ID == 0) {
            return FLOWER_RED;
        }
        if (ID == 1) {
            return FLOWER_ORA;
        }
        if (ID == 2) {
            return FLOWER_YEL;
        }
        if (ID == 3) {
            return FLOWER_GRN;
        }
        if (ID == 4) {
            return FLOWER_CYA;
        }
        if (ID == 5) {
            return FLOWER_BLU;
        }
        if (ID == 6) {
            return FLOWER_PUR;
        }
        if (ID == 7) {
            return FLOWER_PNK;
        }
        if (ID == 8) {
            return FLOWER_WHT;
        }
        return null;
    }

    public String getJson() {
        return String.format("{\"item\":\"%s:%s\"}", "pmp", this.itemName);
    }

    public String getJson(int count) {
        return String.format("{\"item\":\"%s:%s\",\"count\":%d}", "pmp", this.itemName, count);
    }
}

