/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.def;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.EnumDyeColor;
import pmp.core.type.TypeHabitat;

public enum DefHabitat {
    TREE_EPIPHYTE("epip", TypeHabitat.EPIPHYTE, '5', EnumDyeColor.MAGENTA),
    TREE_VINE("vine", TypeHabitat.VINE, 'd', EnumDyeColor.LIME),
    LAND_BIOME_EDGE("bedg", TypeHabitat.LAND, 'a', EnumDyeColor.GREEN),
    LAND_BIOME_EDGE_SLOPE("beds", TypeHabitat.LAND, 'a', EnumDyeColor.LIME),
    LAND_OPEN("open", TypeHabitat.LAND, 'a', EnumDyeColor.RED),
    LAND_SHADE("shad", TypeHabitat.LAND, '2', EnumDyeColor.ORANGE),
    LAND_SLOPE("slop", TypeHabitat.LAND, 'a', EnumDyeColor.PURPLE),
    LAND_SLOPE_SHADE("slps", TypeHabitat.LAND, '2', EnumDyeColor.WHITE),
    LAND_WATER_EDGE("wedg", TypeHabitat.LAND, 'a', EnumDyeColor.LIGHT_BLUE),
    LAND_WATER_EDGE_SHADE("weds", TypeHabitat.LAND, '2', EnumDyeColor.CYAN),
    LAND_TREE_BASE("trba", TypeHabitat.LAND, '6', EnumDyeColor.BROWN),
    FRESHWATER_DEEP("frdp", TypeHabitat.FRESHWATER, 'b', EnumDyeColor.WHITE),
    FRESHWATER_FLOATING("frfl", TypeHabitat.FRESHWATER, 'b', EnumDyeColor.YELLOW),
    FRESHWATER_MARGIN("frmr", TypeHabitat.FRESHWATER, 'b', EnumDyeColor.PINK),
    MARINE_DEEP("madp", TypeHabitat.MARINE, '9', EnumDyeColor.WHITE),
    MARINE_FLOATING("mafl", TypeHabitat.MARINE, '9', EnumDyeColor.GRAY),
    MARINE_MARGIN("mamr", TypeHabitat.MARINE, '9', EnumDyeColor.SILVER);

    public final String habitatName;
    public final TypeHabitat type;
    public final char colorCode;
    public final EnumDyeColor dyeColor;

    private DefHabitat(String resourceName, TypeHabitat type, char colorCode, EnumDyeColor dyeColor) {
        this.habitatName = resourceName;
        this.type = type;
        this.colorCode = colorCode;
        this.dyeColor = dyeColor;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)("habitat." + this.habitatName), (Object[])new Object[0]);
    }

    public String getLocalizedNameFormatted() {
        return String.format("\u00a7%s%s\u00a7r", Character.valueOf(this.colorCode), I18n.func_135052_a((String)String.format("habitat.%s", this.habitatName), (Object[])new Object[0]));
    }

    public boolean canHabitatContainTrees() {
        if (this.type == TypeHabitat.LAND) {
            return this != TREE_EPIPHYTE && this != TREE_VINE && this != LAND_SHADE && this != LAND_SLOPE_SHADE && this != LAND_WATER_EDGE_SHADE && this != LAND_TREE_BASE;
        }
        return false;
    }

    public static DefHabitat getHabitatFromName(String name) {
        for (DefHabitat habitat : DefHabitat.values()) {
            if (!name.matches(habitat.habitatName)) continue;
            return habitat;
        }
        return null;
    }

    public boolean isLandHabitat() {
        return this.type == TypeHabitat.LAND;
    }

    public boolean isWaterHabitat() {
        return this.type == TypeHabitat.FRESHWATER || this.type == TypeHabitat.MARINE;
    }
}

