/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitSavan
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 40;
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 5;
                dataHabitat.worldgenRateTrees = 5;
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 25;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 25;
                dataHabitat.worldgenRateTrees = 25;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_CRMIS, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_HARMI, 50, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.PLAIN_SWGRA, 50, 2, 25, 2);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DAHLI_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.SAVAN_BUTWD, 50, 2, 25, 3);
                dataHabitat.addPlant(DefPlant.SAVAN_DEVSH, 50, 2, 25, 3);
                dataHabitat.addPlant(DefPlant.SAVAN_HOARV, 50, 2, 25, 3);
                dataHabitat.addPlant(DefPlant.SAVAN_LEADP, 50, 2, 25, 3);
                dataHabitat.addPlant(DefPlant.SAVAN_PALEY, 50, 2, 25, 3);
                dataHabitat.addPlant(DefPlant.SAVAN_PIEMV, 50, 2, 25, 3);
                dataHabitat.addPlant(DefPlant.SAVAN_PROPP, 50, 2, 25, 3);
                dataHabitat.addPlant(DefPlant.SAVAN_SHOCA, 50, 2, 25, 3);
                dataHabitat.addPlant(DefPlant.MEDIU_YELJA, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_MADOC, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_MALTA, 50, 1, 20, 2);
                break;
            }
            case LAND_SHADE: {
                dataHabitat.addPlant(DefPlant.SAVAN_TEXTI, 50, 1, 25, 2);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.MEDIU_WOOLB, 50, 2, 35, 2);
                break;
            }
            case LAND_SLOPE_SHADE: {
                dataHabitat.addPlant(DefPlant.MEDIU_WOOLB, 50, 2, 35, 2);
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.SAVAN_TEXTI, 50, 1, 35, 0);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.addPlant(DefPlant.SAVAN_TEXTI, 50, 1, 35, 0);
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addTree(DefTree.ACACI_BAOBO, 50);
                dataHabitat.addTree(DefTree.NUT_MACAD, 5);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addTree(DefTree.ACACI_WHIST, 50);
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addTree(DefTree.ACACI_CUCUM, 10);
                dataHabitat.addTree(DefTree.ACACI_RIVBU, 50);
                break;
            }
        }
    }
}

