/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitRivec
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 15;
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.FOREC_ARCGE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_BUTTB, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_JUNSA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_KERRI, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_LAVEN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_WILDM, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_WOLKN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_WOODS, 50, 1, 20, 1);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.FOREC_WOODS, 50, 1, 25, 2);
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.MEDIU_DWAPI, 50, 1, 20, 1);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.FOREC_MAIDS, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_WOODS, 10, 1, 25, 2);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 50, 1, 15, 0);
                dataHabitat.addPlant(DefPlant.WETLA_FLORU, 10, 1, 15, 0);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 50, 1, 20, 1);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.addPlant(DefPlant.FRESH_CAWAW, 50, 2, 25, 0);
                dataHabitat.addPlant(DefPlant.FRESH_COONT, 50, 1, 15, 0);
                dataHabitat.addPlant(DefPlant.FRESH_MONDG, 50, 1, 15, 0);
                dataHabitat.addPlant(DefPlant.FRESH_WRWAN, 50, 1, 15, 0);
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.addPlant(DefPlant.CROPA_WASAB, 5, 1, 5, 0);
                dataHabitat.addPlant(DefPlant.IMMER_GREYS, 50, 1, 15, 0);
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addTree(DefTree.BIRCH_WATER, 50);
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

