/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitPlain
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 15;
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case FRESHWATER_FLOATING: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.PLAIN_MEADF, 40, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_SWGRA, 60, 3, 25, 2);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.MEDIU_PRAJG, 40, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.PLAIN_SWGRA, 60, 3, 25, 2);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.BBUSH_BLACK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.BBUSH_GOOSE, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.BBUSH_STRAW, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_CELOS_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_MARIG_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_GFEGR, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_SUMAS, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.PLAIN_CGLDR, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_CULVR, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_HOARP, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_JACLA, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_LAZBE, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_LIONT, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_MOTTL, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_NORBE, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_PRBLS, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_PRBRO, 50, 1, 10, 2);
                dataHabitat.addPlant(DefPlant.PLAIN_PRSAG, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_PURCF, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_RECGR, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.PLAIN_ROSCA, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_SHFLE, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_SMAST, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_SMPAF, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_STNET, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_SWGRA, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_THFAV, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_TUFHG, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_VIOLE, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_WILDA, 50, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_WINTB, 50, 1, 10, 1);
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.MEDIU_PRAJG, 30, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.PLAIN_SHSTA, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_SWGRA, 70, 3, 25, 2);
                dataHabitat.addPlant(DefPlant.PLAIN_YELTF, 10, 1, 20, 1);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.WETLA_CATTA, 90, 2, 35, 0);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 10, 1, 25, 0);
                dataHabitat.addPlant(DefPlant.WETLA_COMRU, 10, 1, 25, 0);
                dataHabitat.addPlant(DefPlant.WETLA_FLORU, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_PICKW, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 15, 1, 30, 2);
                dataHabitat.addPlant(DefPlant.WETLA_WAHOR, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_WHTTH, 5, 1, 20, 0);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.addPlant(DefPlant.FRESH_CAWAW, 50, 2, 30, 1);
                dataHabitat.addPlant(DefPlant.FRESH_COONT, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_DWHGR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_MONDG, 50, 1, 20, 1);
                break;
            }
            case FRESHWATER_FLOATING: {
                dataHabitat.addPlant(DefPlant.FLOAT_ARRLL, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_CRFLH, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_DUCKW, 80, 2, 50, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_RERFL, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_VARPL, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WACHE, 15, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WAHYA, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALET, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_BLU, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_CYA, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_GRN, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_ORA, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_PNK, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_PUR, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_RED, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_WHT, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_YEL, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WASHI, 5, 1, 20, 0);
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.addPlant(DefPlant.IMMER_ARRAR, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_COMRD, 80, 2, 40, 0);
                dataHabitat.addPlant(DefPlant.IMMER_DUCKP, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_EURBR, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_SIMBR, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_SOFBU, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_WAMAN, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_YELFL, 5, 1, 10, 0);
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addTree(DefTree.OAK_BLUE, 50);
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

