/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;

public class DataInitOcean
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case MARINE_DEEP: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case MARINE_FLOATING: {
                break;
            }
            case MARINE_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.BEACH_HITBU, 50, 2, 20, 1);
                dataHabitat.addPlant(DefPlant.BEACH_SEAOA, 10, 2, 20, 1);
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.BEACH_SEALY, 50, 3, 35, 0);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.BEACH_SEASA, 50, 3, 35, 0);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case MARINE_DEEP: {
                dataHabitat.addPlant(DefPlant.SALTW_COMEE, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.SALTW_CORWE, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.SALTW_GKELG, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.SALTW_GKELY, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.SALTW_MOZUK, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.SALTW_ROCKW, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.SALTW_SEAGR, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.SALTW_SEALE, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.SALTW_TANGL, 10, 0, 0, 0);
                break;
            }
            case MARINE_FLOATING: {
                break;
            }
            case MARINE_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

