/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitMount
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 15;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 15;
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 5;
                dataHabitat.worldgenRateTrees = 5;
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 10;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 20;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_APADW, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_ARTCO, 20, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_TURKT, 5, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.MOUNT_COWPA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_MOARN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_SCATR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_YELBE, 50, 1, 20, 1);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.MOUNT_SILMG, 50, 1, 20, 2);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.BBUSH_HUCKL, 15, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_DELPH_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HAWKW_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_BETRD, 15, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_MOCAT, 15, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.MEDIU_DWAPI, 15, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.MEDIU_JAPIE, 15, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.MOUNT_ALPAR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_ALPBE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_ALPCU, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_BEBEF, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_BISTO, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_CANDA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_COWPA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_DAPHN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_EDELW, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_ELEAR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_FOXGL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_GRYGE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_HOUSL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_IRIS, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_KINGA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_KRISP, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_MARTL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_MOARN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_NORWH, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_PELBE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_SCATR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_SILMG, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_SPIRA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_WEEPF, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_WHTAS, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_WHTHE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_YELBE, 50, 1, 20, 1);
                break;
            }
            case LAND_SHADE: {
                dataHabitat.addPlant(DefPlant.GRNDC_LVGRN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.GRNDC_TWIG, 5, 1, 20, 1);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_COLUM_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_ZIMAL, 15, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_ALPAR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_ALPBE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_ALPCU, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_BEBEF, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_BISTO, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_CANDA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_COWPA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_DAPHN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_EDELW, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_ELEAR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_FOXGL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_GRYGE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_HOUSL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_IRIS, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_KINGA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_KRISP, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_MARTL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_MOARN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_NORWH, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_PELBE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_SCATR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_SILMG, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_SPIRA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_WEEPF, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_WHTAS, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_WHTHE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_YELBE, 50, 1, 20, 1);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.BAMB_FARGE, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 50, 1, 15, 0);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 50, 1, 20, 1);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.addPlant(DefPlant.MOUNT_SILMG, 50, 1, 20, 2);
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.addPlant(DefPlant.FRESH_MONDG, 50, 1, 20, 1);
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.addPlant(DefPlant.CROPA_WASAB, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_GREYS, 50, 0, 0, 0);
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                dataHabitat.addTree(DefTree.BIRCH_SILVE, 50);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addTree(DefTree.BIRCH_WHTGR, 50);
                dataHabitat.addTree(DefTree.BIRCH_WHTOR, 50);
                dataHabitat.addTree(DefTree.BIRCH_WHTRE, 50);
                dataHabitat.addTree(DefTree.BIRCH_WHTYE, 50);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addTree(DefTree.BIRCH_CHDWA, 15);
                dataHabitat.addTree(DefTree.BIRCH_SILVE, 10);
                dataHabitat.addTree(DefTree.SPRUC_BLACK, 50);
                dataHabitat.addTree(DefTree.SPRUC_MARTI, 50);
                dataHabitat.addTree(DefTree.SPRUC_NORWA, 75);
                dataHabitat.addTree(DefTree.SPRUC_RED, 50);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addTree(DefTree.BIRCH_WHTGR, 80);
                dataHabitat.addTree(DefTree.BIRCH_WHTOR, 40);
                dataHabitat.addTree(DefTree.BIRCH_WHTRE, 40);
                dataHabitat.addTree(DefTree.BIRCH_WHTYE, 40);
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addTree(DefTree.BIRCH_WATER, 50);
                break;
            }
        }
    }
}

