/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitMesa
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case LAND_SHADE: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 15;
                dataHabitat.worldgenRateTrees = 5;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_SULSH, 50, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.DESER_APAPL, 50, 1, 15, 1);
                dataHabitat.addPlant(DefPlant.DESER_SEEPW, 50, 1, 15, 1);
                dataHabitat.addPlant(DefPlant.DESER_WHTSA, 50, 1, 15, 1);
                dataHabitat.addPlant(DefPlant.SAVAN_TEXTI, 10, 1, 15, 1);
                break;
            }
            case LAND_SHADE: {
                dataHabitat.addPlant(DefPlant.FUNGU_BLPOW, 50, 1, 15, 1);
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.WETLA_CATTA, 50, 2, 40, 0);
                dataHabitat.addPlant(DefPlant.WETLA_WAHOR, 5, 1, 25, 0);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 10, 1, 25, 1);
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.addPlant(DefPlant.IMMER_SIMBR, 50, 1, 15, 0);
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addTree(DefTree.ACACI_RIVBU, 50);
                break;
            }
        }
    }
}

