/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitJungl
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.plantCanReplacePlants = true;
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 45;
                break;
            }
            case TREE_VINE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 10;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 10;
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 15;
                dataHabitat.worldgenRateTrees = 20;
                break;
            }
            case LAND_SHADE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 15;
                break;
            }
            case LAND_SLOPE_SHADE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 5;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
            case FRESHWATER_FLOATING: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_CRCAT, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_FIBCA, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_FRAGF, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_SKYPL, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_SULSH, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_TAMPO, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_WILDF, 50, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                dataHabitat.addPlant(DefPlant.VINE_BLSKY, 25, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_JADEV, 25, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_MADEV, 25, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_MYSTR, 25, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_BLU, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_CYA, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_GRN, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_ORA, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_PNK, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_PUR, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_RED, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_WHT, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_YEL, 5, 0, 0, 0);
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.BBUSH_BEAUT, 25, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_BLU, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_CYA, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_GRN, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_ORA, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_PNK, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_PUR, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_RED, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_WHT, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_YEL, 50, 1, 15, 2);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.BBUSH_BEAUT, 25, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_BLU, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_CYA, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_GRN, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_ORA, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_PNK, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_PUR, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_RED, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_WHT, 50, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_ANGTR_YEL, 50, 1, 15, 2);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_HYDRA_YEL, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_BIRDP, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_BRHEM, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_BRLAC, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_CANCO, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_CANGL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_CANIN, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_CHGUZ, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_DEVTO, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_DWPAL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_HONSP, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_HELAC, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_LINDE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_LOLPL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_MADPA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_MARCE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_PALML, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_PANQU, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_PARBE, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_PHDUC, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_PORAL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_RACFR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_RICDR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_SHFLO, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_SILVA, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_TORGI, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.JUNGL_VOODL, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_DWSUP, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_GCANE, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_GELEA, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_PYDAP, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_QUSAG, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.LARGE_RESWP, 50, 1, 20, 2);
                break;
            }
            case LAND_SHADE: {
                dataHabitat.addPlant(DefPlant.FUNGU_CHANT, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_DEATC, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_GCLUB, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_PARAS, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_STNKH, 70, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_WEMIC, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_WOODB, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_WOOLG, 10, 1, 20, 1);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.CLIMB_BRCRE, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.CLIMB_HYACB, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.CLIMB_KIWI, 50, 0, 0, 0);
                break;
            }
            case LAND_SLOPE_SHADE: {
                dataHabitat.addPlant(DefPlant.CLIMB_BRCRE, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.CLIMB_HYACB, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.CLIMB_KIWI, 50, 0, 0, 0);
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.BAMB_ASPER, 5, 1, 30, 0);
                dataHabitat.addPlant(DefPlant.BAMB_GLDBA, 5, 1, 30, 0);
                dataHabitat.addPlant(DefPlant.BAMB_GTIMB, 5, 1, 30, 0);
                dataHabitat.addPlant(DefPlant.BAMB_MOSO, 5, 1, 30, 0);
                dataHabitat.addPlant(DefPlant.BAMB_TIMOR, 5, 1, 30, 0);
                dataHabitat.addPlant(DefPlant.BAMB_TROPB, 5, 1, 30, 0);
                dataHabitat.addPlant(DefPlant.WETLA_CATTA, 90, 3, 35, 0);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 10, 1, 25, 0);
                dataHabitat.addPlant(DefPlant.WETLA_COMRU, 10, 1, 25, 0);
                dataHabitat.addPlant(DefPlant.WETLA_FLORU, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 15, 1, 30, 2);
                dataHabitat.addPlant(DefPlant.WETLA_WAHOR, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_WHTTH, 5, 1, 20, 0);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.addPlant(DefPlant.WETLA_PICKW, 50, 1, 20, 0);
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.addPlant(DefPlant.JUNGL_STCLU, 50, 1, 20, 1);
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.addPlant(DefPlant.FRESH_AMAZS, 80, 2, 30, 1);
                dataHabitat.addPlant(DefPlant.FRESH_CRYWE, 15, 2, 30, 1);
                dataHabitat.addPlant(DefPlant.FRESH_DWHGR, 10, 2, 30, 1);
                dataHabitat.addPlant(DefPlant.FRESH_EELGR, 10, 2, 30, 1);
                dataHabitat.addPlant(DefPlant.FRESH_MONDG, 25, 2, 30, 1);
                dataHabitat.addPlant(DefPlant.FRESH_WAWIS, 10, 2, 30, 1);
                break;
            }
            case FRESHWATER_FLOATING: {
                dataHabitat.addPlant(DefPlant.FLOAT_CRFLH, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_DUCKW, 80, 2, 50, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_VARPL, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WACHE, 15, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WAHYA, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALET, 20, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_BLU, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_CYA, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_GRN, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_ORA, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_PNK, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_PUR, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_RED, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_WHT, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_YEL, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WASHI, 5, 1, 20, 0);
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.addPlant(DefPlant.CROPA_TARO, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_ARRAR, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_COMRD, 85, 2, 40, 0);
                dataHabitat.addPlant(DefPlant.IMMER_DUCKP, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_EURBR, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_SIMBR, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_SOFBU, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_WAMAN, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_YELFL, 5, 1, 10, 0);
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                dataHabitat.addTree(DefTree.JUNGL_BOMBO, 50);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addTree(DefTree.JUNGL_ACAI, 50);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addTree(DefTree.JUNGL_BANAN, 5);
                dataHabitat.addTree(DefTree.JUNGL_BOMBO, 50);
                dataHabitat.addTree(DefTree.JUNGL_COCON, 5);
                dataHabitat.addTree(DefTree.NUT_BRAZI, 5);
                dataHabitat.addTree(DefTree.NUT_CANDL, 5);
                dataHabitat.addTree(DefTree.NUT_CASHE, 5);
                dataHabitat.addTree(DefTree.NUT_GABON, 5);
                dataHabitat.addTree(DefTree.NUT_MAYA, 5);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addTree(DefTree.JUNGL_ACAI, 50);
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addTree(DefTree.JUNGL_BOMBO, 50);
                break;
            }
        }
    }
}

