/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;

public class DataInitFrozr
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.plantCanReplaceSnow = true;
        biome.treeCanReplaceSnow = true;
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.FOREC_ARCGE, 10, 1, 25, 1);
                dataHabitat.addPlant(DefPlant.FOREC_JUNSA, 80, 1, 25, 1);
                dataHabitat.addPlant(DefPlant.MOUNT_ALPCU, 10, 1, 25, 1);
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.FOREC_JUNSA, 50, 1, 25, 1);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

