/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitBeacw
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
            case TREE_VINE: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 35;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 25;
                dataHabitat.worldgenRateTrees = 35;
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 8;
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.worldgenRatePlants = 30;
                break;
            }
            case MARINE_DEEP: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
            case MARINE_FLOATING: {
                break;
            }
            case MARINE_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_TAMPO, 50, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                dataHabitat.addPlant(DefPlant.VINE_JADEV, 50, 0, 0, 0);
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.BEACH_BUTSA, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_HITBU, 25, 2, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_SEAOA, 15, 3, 25, 2);
                dataHabitat.addPlant(DefPlant.BEACH_SHAST, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_THGHY, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_BLU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_CYA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_GRN, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_ORA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_PNK, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_PUR, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_RED, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_WHT, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FLOWR_NEMES_YEL, 5, 1, 20, 1);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.BEACH_HITBU, 50, 2, 20, 2);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.BEACH_DUSMI, 2, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.BEACH_MESHO, 2, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.BEACH_PRMAD, 2, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.BEACH_RPRAG, 2, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.BEACH_SAMBB, 2, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.BEACH_SEALA, 2, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.BEACH_SEALY, 2, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.BEACH_SEAOA, 85, 3, 25, 2);
                dataHabitat.addPlant(DefPlant.BEACH_SOIPB, 2, 1, 10, 1);
                dataHabitat.addPlant(DefPlant.BEACH_SPICB, 2, 1, 10, 1);
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.BEACH_DUSMI, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_MESHO, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_PRMAD, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_RPRAG, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_SAMBB, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_SEALA, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_SEALY, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_SOIPB, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_SPICB, 50, 1, 25, 1);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.BEACH_SEASA, 50, 3, 35, 0);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.addPlant(DefPlant.BEACH_SCTRF, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.BEACH_SEASA, 50, 1, 20, 2);
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.addPlant(DefPlant.BEACH_SCTRF, 10, 1, 25, 1);
                break;
            }
            case MARINE_DEEP: {
                dataHabitat.addPlant(DefPlant.SALTW_GKELG, 50, 3, 15, 2);
                dataHabitat.addPlant(DefPlant.SALTW_GKELY, 50, 3, 15, 2);
                break;
            }
            case MARINE_FLOATING: {
                break;
            }
            case MARINE_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                dataHabitat.addTree(DefTree.JUNGL_BOMBO, 50);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addTree(DefTree.JUNGL_BANAN, 50);
                dataHabitat.addTree(DefTree.JUNGL_COCON, 50);
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

