/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data;

import java.io.PrintWriter;
import pmp.core.def.DefHabitat;
import pmp.core.def.DefTree;

public class DataHabitatTree {
    private final DefHabitat habitat;
    private final DefTree defTree;
    public int spawnWeight;

    public DataHabitatTree(DefHabitat habitat, DefTree defTree) {
        this.habitat = habitat;
        this.defTree = defTree;
        this.applyDefaultSettings();
    }

    public DataHabitatTree(DefHabitat habitat, DefTree defTree, int spawnWeight) {
        this.habitat = habitat;
        this.defTree = defTree;
        this.spawnWeight = spawnWeight;
    }

    public DefTree getDefTree() {
        return this.defTree;
    }

    public void applyDefaultSettings() {
        this.spawnWeight = this.defTree.hasFruit() ? 25 : 50;
    }

    public void loadSettings(String dataLine) {
        String[] data = dataLine.split(",");
        this.spawnWeight = Integer.valueOf(data[1]);
    }

    public void saveSettings(PrintWriter pw) {
        pw.println(String.format("h.%s:t|%s,%d", this.habitat.habitatName, this.defTree.blockName, this.spawnWeight));
    }
}

