/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Level;
import pmp.PlantMegaPack;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefHabitat;
import pmp.core.type.TypeBiome;

public class DataBiome {
    public final TypeBiome typeBiome;
    private DataInit dataInit;
    public Map<DefHabitat, DataHabitat> habitats = new TreeMap<DefHabitat, DataHabitat>();
    public int worldgenRatePlants;
    public int worldgenRateTrees;
    public boolean plantCanReplacePlants;
    public boolean plantCanReplaceSnow;
    public boolean treeCanReplacePlants;
    public boolean treeCanReplaceSnow;

    public DataBiome(TypeBiome biome) {
        this.typeBiome = biome;
        try {
            Constructor<? extends DataInit> dataInitCon = this.typeBiome.dataInitClass.getConstructor(new Class[0]);
            this.dataInit = dataInitCon.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (DefHabitat defHabitat : DefHabitat.values()) {
            DataHabitat dataHabitat;
            if (!this.typeBiome.getHabitats().contains((Object)defHabitat) || (dataHabitat = new DataHabitat(this.typeBiome, defHabitat)) == null) continue;
            this.habitats.put(defHabitat, dataHabitat);
        }
        this.worldgenRatePlants = 0;
        this.worldgenRateTrees = 0;
        this.plantCanReplacePlants = false;
        this.plantCanReplaceSnow = false;
        this.treeCanReplacePlants = false;
        this.treeCanReplaceSnow = false;
    }

    public void initAllDefaultSettings(boolean useDefaultSettings) {
        this.applyDefaultBiomeSettings(useDefaultSettings);
        for (DefHabitat defHabitat : DefHabitat.values()) {
            DataHabitat dataHabitat = this.habitats.get((Object)defHabitat);
            if (dataHabitat == null) continue;
            if (useDefaultSettings) {
                this.dataInit.applyDefaultHabitatSettings(dataHabitat);
            } else {
                dataHabitat.initSettings(false);
            }
            dataHabitat.applyDefaultHabitatPlants(this.dataInit, useDefaultSettings);
            dataHabitat.applyDefaultHabitatTrees(this.dataInit, useDefaultSettings);
        }
    }

    public void applyDefaultBiomeSettings(boolean useDefaultSettings) {
        this.worldgenRatePlants = 0;
        this.worldgenRateTrees = 0;
        this.plantCanReplacePlants = false;
        this.plantCanReplaceSnow = false;
        this.treeCanReplacePlants = false;
        this.treeCanReplaceSnow = false;
        if (useDefaultSettings) {
            this.dataInit.applyDefaultBiomeSettings(this);
        }
    }

    public void applyDefaultHabitatSettings(DefHabitat defHabitat) {
        DataHabitat dataHabitat = this.habitats.get((Object)defHabitat);
        if (dataHabitat != null) {
            dataHabitat.applyDefaultHabitatSettings(this.dataInit);
        }
    }

    public void applyDefaultHabitatPlants(DefHabitat defHabitat, boolean addDefaultPlants) {
        DataHabitat dataHabitat = this.habitats.get((Object)defHabitat);
        if (dataHabitat != null) {
            dataHabitat.applyDefaultHabitatPlants(this.dataInit, addDefaultPlants);
        }
    }

    public void applyDefaultHabitatTrees(DefHabitat defHabitat, boolean addDefaultTrees) {
        DataHabitat dataHabitat = this.habitats.get((Object)defHabitat);
        if (dataHabitat != null) {
            dataHabitat.applyDefaultHabitatTrees(this.dataInit, addDefaultTrees);
        }
    }

    public void loadSettings(String dataLine) {
        String[] data = dataLine.split("\\.");
        if (data[0].equals("c")) {
            this.setConfigOption(data[1]);
        } else if (data[0].equals("h")) {
            this.setHabitatOption(data[1]);
        } else {
            PlantMegaPack.instance.logOutput(Level.WARN, String.format("Invalid biome config line \"%s\" ignored", dataLine));
        }
    }

    private void setConfigOption(String optionData) {
        String[] data = optionData.split(":");
        if (data[0].equals("plantCanReplacePlants")) {
            this.plantCanReplacePlants = data[1].equals("true");
        } else if (data[0].equals("plantCanReplaceSnow")) {
            this.plantCanReplaceSnow = data[1].equals("true");
        } else if (data[0].equals("treeCanReplacePlants")) {
            this.treeCanReplacePlants = data[1].equals("true");
        } else if (data[0].equals("treeCanReplaceSnow")) {
            this.treeCanReplaceSnow = data[1].equals("true");
        } else if (data[0].equals("worldgenRatePlants")) {
            this.worldgenRatePlants = Integer.parseInt(data[1]);
        } else if (data[0].equals("worldgenRateTrees")) {
            this.worldgenRateTrees = Integer.parseInt(data[1]);
        }
    }

    private void setHabitatOption(String optionData) {
        String[] data = optionData.split(":");
        DefHabitat habitat = DefHabitat.getHabitatFromName(data[0]);
        if (habitat != null) {
            DataHabitat dataHabitat = this.habitats.get((Object)habitat);
            if (dataHabitat == null) {
                dataHabitat = new DataHabitat(this.typeBiome, habitat);
                this.habitats.put(habitat, dataHabitat);
            }
            dataHabitat.loadSettings(data[1]);
        }
    }

    public void saveSettings(PrintWriter printwriter) {
        printwriter.println(String.format("c.plantCanReplacePlants:%s", this.plantCanReplacePlants ? "true" : "false"));
        printwriter.println(String.format("c.plantCanReplaceSnow:%s", this.plantCanReplaceSnow ? "true" : "false"));
        printwriter.println(String.format("c.treeCanReplacePlants:%s", this.treeCanReplacePlants ? "true" : "false"));
        printwriter.println(String.format("c.treeCanReplaceSnow:%s", this.treeCanReplaceSnow ? "true" : "false"));
        printwriter.println(String.format("c.worldgenRatePlants:%d", this.worldgenRatePlants));
        printwriter.println(String.format("c.worldgenRateTrees:%d", this.worldgenRateTrees));
        this.habitats.forEach((k, v) -> v.saveSettings(printwriter));
    }
}

