/*
 * Decompiled with CFR 0.152.
 */
package pmp.core;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import pmp.PlantMegaPack;

public abstract class ModHelpers {
    public static void outputModInfo() {
        PlantMegaPack.instance.logOutput(Level.INFO, "-------------------------------------");
        PlantMegaPack.objects.outputLogInfo();
        PlantMegaPack.instance.logOutput(Level.INFO, "-------------------------------------");
    }

    public static File openFile(String filePath) {
        File file = null;
        try {
            file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return file;
    }

    public static boolean createDirectory(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            try {
                dir.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static void deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (File aFile : files) {
                    ModHelpers.deleteDirectory(aFile);
                }
            }
            dir.delete();
        } else {
            dir.delete();
        }
    }

    public static AxisAlignedBB getPlantAABB(AxisAlignedBB baseAABB, BlockPos pos) {
        long l = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
        return baseAABB.func_72317_d(((double)((float)(l >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5, 0.0, ((double)((float)(l >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5);
    }

    public static SoundType getSoundFromMaterial(Material material) {
        if (material == Material.field_151592_s) {
            return SoundType.field_185853_f;
        }
        if (material == Material.field_151573_f) {
            return SoundType.field_185852_e;
        }
        if (material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151582_l) {
            return SoundType.field_185850_c;
        }
        if (material == Material.field_151576_e) {
            return SoundType.field_185851_d;
        }
        if (material == Material.field_151595_p) {
            return SoundType.field_185855_h;
        }
        if (material == Material.field_151575_d) {
            return SoundType.field_185848_a;
        }
        return SoundType.field_185851_d;
    }

    public static int countPlantHeightFromBottom(World world, BlockPos posBottom, Block block) {
        BlockPos pos = posBottom;
        int height = 0;
        do {
            pos = pos.func_177984_a();
            ++height;
        } while (world.func_180495_p(pos).func_177230_c() == block);
        return height;
    }

    public static int countPlantHeightFromTop(World world, BlockPos posTop, Block block) {
        BlockPos pos = posTop;
        int height = 0;
        do {
            pos = pos.func_177977_b();
            ++height;
        } while (world.func_180495_p(pos).func_177230_c() == block);
        return height;
    }

    public static boolean isFullWaterBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a() != Material.field_151586_h) {
            return false;
        }
        return (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    public static void spawnWaterSplashParticles(World world, BlockPos pos) {
        world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.45f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.55f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
    }
}

