/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.lang.reflect.Constructor;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pmp.core.def.DefTree;
import pmp.worldgen.tree.GenTreeBase;

public class BlockTreeSapling
extends BlockBush
implements IGrowable {
    protected final DefTree defTree;
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);

    public BlockTreeSapling(DefTree defTree) {
        this.defTree = defTree;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= Integer.valueOf((Integer)state.func_177229_b((IProperty)STAGE)) << 3;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Block.field_185506_k;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        if (this.defTree.canGrowOnSand && soil.func_185904_a() == Material.field_151595_p) {
            return true;
        }
        return super.func_176196_c(world, pos);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState stateSoil = world.func_180495_p(pos.func_177977_b());
        if (stateSoil.func_185904_a() == Material.field_151595_p) {
            return this.defTree.canGrowOnSand;
        }
        return super.func_180671_f(world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(world, pos, state, rand);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public PropertyEnum<?> getVariantProperty() {
        return null;
    }

    public void generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        try {
            Constructor<? extends GenTreeBase> genTreeCon = this.defTree.genTreeClass.getConstructor(DefTree.class, Boolean.TYPE);
            GenTreeBase genTree = genTreeCon.newInstance(new Object[]{this.defTree, true});
            genTree.func_180709_b(world, rand, pos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

