/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.block.BlockPlantSubmerged;
import pmp.core.ModHelpers;
import pmp.core.def.DefPlant;

public class BlockPlantSubmergedKelp
extends BlockPlantSubmerged
implements IGrowable {
    public BlockPlantSubmergedKelp(DefPlant defPlant) {
        super(defPlant);
        this.func_149675_a(true);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a() != Material.field_151586_h || world.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this || this.canPlantGrowOnBlock(world.func_180495_p(pos.func_177977_b()));
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this && world.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this || this.canPlantGrowOnBlock(world.func_180495_p(pos.func_177977_b()));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.checkAndDropBlock(world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(8) == 0 && this.func_176473_a(world, pos, state, !world.field_72995_K)) {
            this.func_176474_b(world, rand, pos, state);
        }
        this.checkAndDropBlock(world, pos, state);
    }

    private void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 2);
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (!PlantMegaPack.settings.plantKelpCanGrow) {
            return false;
        }
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150355_j || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() != Blocks.field_150355_j) {
            return false;
        }
        int height = ModHelpers.countPlantHeightFromTop(world, pos, this);
        return height < PlantMegaPack.settings.plantKelpMaxHeight;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P(), 2);
    }
}

