/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pmp.block.BlockBasePlant;
import pmp.core.ModHelpers;
import pmp.core.def.DefPlant;
import pmp.core.type.TypePlant;

public class BlockPlantFloating
extends BlockBasePlant {
    protected static final AxisAlignedBB FLOATING_AABB = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.45, 0.85);
    protected static final AxisAlignedBB FLOATING_FLAT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockPlantFloating(DefPlant defPlant) {
        super(defPlant);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_175623_d(pos) && ModHelpers.isFullWaterBlock(world, pos.func_177977_b());
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            return ModHelpers.isFullWaterBlock(world, pos.func_177977_b());
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ModHelpers.spawnWaterSplashParticles(world, pos);
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        ModHelpers.spawnWaterSplashParticles(world, pos);
        super.func_176206_d(world, pos, state);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.defPlant.plantType == TypePlant.FLFLA) {
            return ModHelpers.getPlantAABB(FLOATING_FLAT_AABB, pos);
        }
        return ModHelpers.getPlantAABB(FLOATING_AABB, pos);
    }
}

