/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.block.BlockBasePlant;
import pmp.core.def.DefPlant;
import pmp.core.type.TypePlant;

public class BlockPlantEpiphyte
extends BlockBasePlant {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB AABB_HORZ_SOUTH = new AxisAlignedBB(0.0, 0.12, 0.0, 1.0, 0.38, 0.625);
    protected static final AxisAlignedBB AABB_HORZ_WEST = new AxisAlignedBB(0.375, 0.12, 0.0, 1.0, 0.38, 1.0);
    protected static final AxisAlignedBB AABB_HORZ_NORTH = new AxisAlignedBB(0.0, 0.12, 0.375, 1.0, 0.38, 1.125);
    protected static final AxisAlignedBB AABB_HORZ_EAST = new AxisAlignedBB(0.0, 0.12, 0.0, 0.625, 0.38, 1.0);
    protected static final AxisAlignedBB AABB_VERT_SOUTH = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 1.0);
    protected static final AxisAlignedBB AABB_VERT_WEST = new AxisAlignedBB(0.125, 0.125, 0.125, 1.0, 0.875, 0.875);
    protected static final AxisAlignedBB AABB_VERT_NORTH = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.875);
    protected static final AxisAlignedBB AABB_VERT_EAST = new AxisAlignedBB(0.0, 0.125, 0.125, 0.875, 0.875, 0.875);

    public BlockPlantEpiphyte(DefPlant defPlant) {
        super(defPlant);
        if (defPlant.plantType == TypePlant.EPIFU) {
            this.func_149711_c(1.0f);
            this.func_149672_a(SoundType.field_185848_a);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)((meta & 0xC) >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return this.canAttachToBlock(world, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            return false;
        }
        return this.canAttachToBlock(world, pos.func_177972_a(side.func_176734_d()), side);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB aabb = Block.field_185505_j;
        if (source.func_180495_p(pos).func_177230_c() == this) {
            EnumFacing facing = (EnumFacing)source.func_180495_p(pos).func_177229_b((IProperty)FACING);
            boolean horizontal = this.defPlant.plantType == TypePlant.EPIFU;
            switch (facing) {
                case SOUTH: {
                    aabb = horizontal ? AABB_HORZ_SOUTH : AABB_VERT_SOUTH;
                    break;
                }
                case NORTH: {
                    aabb = horizontal ? AABB_HORZ_NORTH : AABB_VERT_NORTH;
                    break;
                }
                case EAST: {
                    aabb = horizontal ? AABB_HORZ_EAST : AABB_VERT_EAST;
                    break;
                }
                case WEST: {
                    aabb = horizontal ? AABB_HORZ_WEST : AABB_VERT_WEST;
                    break;
                }
            }
        }
        return aabb;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean flag) {
        if (this.defPlant.plantType == TypePlant.EPIFU) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185900_c((IBlockAccess)world, pos));
        }
    }

    private boolean canAttachToBlock(World world, BlockPos pos, EnumFacing attachSide) {
        Block hostBlock = world.func_180495_p(pos).func_177230_c();
        if (!world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, attachSide)) {
            return false;
        }
        return hostBlock.isWood((IBlockAccess)world, pos);
    }
}

