/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pmp.block.BlockBasePlant;
import pmp.core.ModHelpers;
import pmp.core.def.DefPlant;
import pmp.core.variant.VariantBlockHalf;

public class BlockPlantDouble
extends BlockBasePlant {
    public static final PropertyEnum<VariantBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", VariantBlockHalf.class);
    protected static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 2.0, 0.85);
    protected static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.15, -1.0, 0.15, 0.85, 1.0, 0.85);

    public BlockPlantDouble(DefPlant defPlant) {
        super(defPlant);
        this.func_180632_j(this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)VariantBlockHalf.BOTTOM)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)VariantBlockHalf.byMetadata((meta & 8) >> 3)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((VariantBlockHalf)((Object)state.func_177229_b(HALF))).getMetadata() << 3;
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180671_f(world, pos, state);
        }
        if (state.func_177229_b(HALF) == VariantBlockHalf.TOP) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState iblockstate = world.func_180495_p(pos.func_177984_a());
        return iblockstate.func_177230_c() == this && super.func_180671_f(world, pos, iblockstate);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && world.func_175623_d(pos.func_177984_a());
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            BlockPlantDouble blockBottom;
            boolean isTopBlock = state.func_177229_b(HALF) == VariantBlockHalf.TOP;
            BlockPos posTop = isTopBlock ? pos : pos.func_177984_a();
            BlockPos posBottom = isTopBlock ? pos.func_177977_b() : pos;
            BlockPlantDouble blockTop = isTopBlock ? this : world.func_180495_p(posTop).func_177230_c();
            BlockPlantDouble blockPlantDouble = blockBottom = isTopBlock ? world.func_180495_p(posBottom).func_177230_c() : this;
            if (!isTopBlock) {
                this.func_176226_b(world, pos, state, 0);
            }
            if (blockTop == this) {
                world.func_180501_a(posTop, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (blockBottom == this) {
                world.func_180501_a(posBottom, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(HALF) == VariantBlockHalf.TOP) {
            return Items.field_190931_a;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(HALF) == VariantBlockHalf.TOP) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (player.field_71075_bZ.field_75098_d) {
                    world.func_175698_g(pos.func_177977_b());
                } else if (world.field_72995_K) {
                    world.func_175698_g(pos.func_177977_b());
                } else {
                    world.func_175655_b(pos.func_177977_b(), true);
                }
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)VariantBlockHalf.TOP)), 2);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((VariantBlockHalf)((Object)state.func_177229_b(HALF))) {
            case BOTTOM: {
                return ModHelpers.getPlantAABB(AABB_BOTTOM, pos);
            }
            case TOP: {
                return ModHelpers.getPlantAABB(AABB_TOP, pos);
            }
        }
        return Block.field_185505_j;
    }
}

