/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.block.BlockBasePlant;
import pmp.core.ModHelpers;
import pmp.core.def.DefPlant;

public class BlockPlantBamboo
extends BlockBasePlant
implements IGrowable {
    public static final PropertyInteger SEGMENT = PropertyInteger.func_177719_a((String)"segment", (int)0, (int)4);
    protected static final AxisAlignedBB AABB_BAMBOO = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockPlantBamboo(DefPlant defPlant) {
        super(defPlant);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SEGMENT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SEGMENT);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            return false;
        }
        int height = ModHelpers.countPlantHeightFromBottom(world, pos, (Block)this);
        if (!world.func_175623_d(pos.func_177981_b(height))) {
            return false;
        }
        return height < PlantMegaPack.settings.plantBambooMaxHeight;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int newHeight = ModHelpers.countPlantHeightFromBottom(world, pos, (Block)this) + 1;
        int segment = -1;
        for (int y = 0; y < newHeight; ++y) {
            if (++segment > 3) {
                segment = 3;
            }
            if (y == newHeight - 1) {
                segment = 4;
            }
            world.func_180501_a(pos.func_177981_b(y), this.func_176223_P().func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf(segment)), 2);
        }
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf(4));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        BlockPos posAbove = pos.func_177972_a(EnumFacing.UP);
        IBlockState iblockstate = world.func_180495_p(posAbove);
        Block block = iblockstate.func_177230_c();
        if (block == this && PlantMegaPack.settings.plantBambooDropsOnBreak) {
            block.func_176226_b(world, posAbove, iblockstate, 0);
            world.func_180501_a(posAbove, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (state.func_177230_c() == this && world.func_175623_d(pos.func_177984_a()) && (Integer)state.func_177229_b((IProperty)SEGMENT) != 4) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf(4)), 3);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(8) == 0 && this.func_176473_a(world, pos, state, !world.field_72995_K)) {
            this.func_176474_b(world, rand, pos, state);
        }
        super.func_180650_b(world, pos, state, rand);
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (!PlantMegaPack.settings.plantBambooDropsOnBreak) {
            return true;
        }
        BlockPos posBelow = pos.func_177977_b();
        Block soil = world.func_180495_p(posBelow).func_177230_c();
        if (soil == this) {
            return true;
        }
        return super.func_180671_f(world, pos, state);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ModHelpers.getPlantAABB(AABB_BAMBOO, pos);
    }
}

