/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.block.BlockBaseBlock;
import pmp.core.def.DefBlock;

public abstract class BlockObjSlab
extends BlockBaseBlock {
    public static final PropertyEnum<BlockSlab.EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockSlab.EnumBlockHalf.class);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public BlockObjSlab(DefBlock defBlock) {
        super(defBlock);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (!this.isDouble()) {
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(iblockstate);
        this.field_149787_q = this.isDouble();
        this.func_149713_g(255);
    }

    protected BlockStateContainer func_180661_e() {
        return this.isDouble() ? new BlockStateContainer((Block)this, new IProperty[0]) : new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        if (!this.isDouble()) {
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!this.isDouble() && state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isDouble()) {
            return field_185505_j;
        }
        return state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public boolean func_185481_k(IBlockState state) {
        return ((BlockObjSlab)state.func_177230_c()).isDouble() || state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (((BlockObjSlab)state.func_177230_c()).isDouble()) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.UP && state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP) {
            return BlockFaceShape.SOLID;
        }
        return face == EnumFacing.DOWN && state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return this.isDouble();
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        BlockSlab.EnumBlockHalf side = (BlockSlab.EnumBlockHalf)state.func_177229_b(HALF);
        return side == BlockSlab.EnumBlockHalf.TOP && face == EnumFacing.UP || side == BlockSlab.EnumBlockHalf.BOTTOM && face == EnumFacing.DOWN;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        if (this.isDouble()) {
            return iblockstate;
        }
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate : iblockstate.func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    }

    public int func_149745_a(Random random) {
        return this.isDouble() ? 2 : 1;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return this.isDouble();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (this.isDouble()) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && !super.func_176225_a(blockState, blockAccess, pos, side)) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isHalfSlab(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockObjSlab) {
            return ((BlockObjSlab)block).defBlock.getBlockType().isSlab();
        }
        return false;
    }

    public abstract boolean isDouble();
}

