/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import com.google.common.base.Predicate;
import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.core.ModCreativeTabs;
import pmp.core.def.DefWorkbench;
import pmp.tileentity.TileEntityBase;

public class BlockBaseWorkbench
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private DefWorkbench defWorkbench;

    public BlockBaseWorkbench(DefWorkbench defWorkbench) {
        super(Material.field_151575_d);
        this.defWorkbench = defWorkbench;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(PlantMegaPack.creativeTabs.getTab(ModCreativeTabs.ModTab.PMP));
        this.func_149675_a(false);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.field_149790_y = false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)((meta & 0xC) >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void onNeighborChange(IBlockAccess source, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(source, pos, neighbor);
        TileEntity tileentity = source.func_175625_s(pos);
        if (tileentity instanceof TileEntityBase) {
            tileentity.func_145836_u();
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_175623_d(pos);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess source, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess source, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess source, BlockPos pos) {
        return false;
    }

    public boolean isFlammable(IBlockAccess source, BlockPos pos, EnumFacing face) {
        return false;
    }

    public int getFlammability(IBlockAccess source, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess source, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ILockableContainer ilockablecontainer;
        if (!world.field_72995_K && (ilockablecontainer = this.getLockableContainer(world, pos)) != null) {
            player.openGui((Object)PlantMegaPack.instance, this.getGuiID(world, pos), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    protected ILockableContainer getLockableContainer(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityBase)) {
            return null;
        }
        if (this.isBlocked(world, pos)) {
            return null;
        }
        return (TileEntityBase)tileentity;
    }

    protected boolean isBlocked(World world, BlockPos pos) {
        return false;
    }

    public int getGuiID(World world, BlockPos pos) {
        return this.defWorkbench.typeTileEntity.tileEntityID;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileEntity tileEntity;
        try {
            Constructor<? extends TileEntity> teCon = this.defWorkbench.typeTileEntity.teClass.getConstructor(new Class[0]);
            tileEntity = teCon.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tileEntity;
    }
}

