/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.core.ModHelpers;
import pmp.core.def.DefItem;
import pmp.core.def.DefPlant;
import pmp.core.type.TypePlantCat;
import pmp.core.type.TypePlantRoot;
import pmp.core.type.TypePlantStem;

public abstract class BlockBasePlant
extends BlockBush
implements IShearable {
    public final DefPlant defPlant;
    protected static final AxisAlignedBB PLANT_AABB = new AxisAlignedBB(0.12, 0.0, 0.12, 0.88, 0.88, 0.88);

    public BlockBasePlant(DefPlant defPlant) {
        super(Material.field_151585_k);
        this.defPlant = defPlant;
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess source, BlockPos pos) {
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityPlayer || entity instanceof EntityPlayerMP) {
            if (PlantMegaPack.settings.realismPoison && this.defPlant.isPoison()) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.func_188412_a((int)19), 3));
            }
            if (PlantMegaPack.settings.realismThorns && this.defPlant.isThorns()) {
                ((EntityLivingBase)entity).func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState stateSoil = world.func_180495_p(pos.func_177977_b());
        if (this.defPlant.canGrowOnSand || stateSoil.func_185904_a() == Material.field_151595_p) {
            return true;
        }
        return super.func_176196_c(world, pos);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState stateSoil = world.func_180495_p(pos.func_177977_b());
        if (stateSoil.func_185904_a() == Material.field_151595_p) {
            return this.defPlant.canGrowOnSand;
        }
        return super.func_180671_f(world, pos, state);
    }

    protected boolean func_185514_i(IBlockState state) {
        if (state.func_185904_a() == Material.field_151595_p) {
            return this.defPlant.canGrowOnSand;
        }
        Block block = state.func_177230_c();
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ModHelpers.getPlantAABB(PLANT_AABB, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean flag) {
        TypePlantCat category = this.defPlant.plantCategory;
        if (category == TypePlantCat.BAMB || category == TypePlantCat.CACTU) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185900_c((IBlockAccess)world, pos));
            return;
        }
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, flag);
    }

    public boolean isShearable(ItemStack stack, IBlockAccess source, BlockPos pos) {
        return this.defPlant.plantType.canBeShearedForParts && this.canPlantBeBrokenIntoParts();
    }

    public List<ItemStack> onSheared(ItemStack stack, IBlockAccess source, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.defPlant.flowerID >= 0) {
            ret.add(new ItemStack(PlantMegaPack.objects.getItem(DefItem.getFlowerFromID(this.defPlant.flowerID)), 1, 0));
        }
        if (this.defPlant.stemID >= 0) {
            ret.add(new ItemStack(PlantMegaPack.objects.getItem(TypePlantStem.getStemItemFromID(this.defPlant.stemID)), 1, 0));
        }
        if (this.defPlant.rootID >= 0) {
            ret.add(new ItemStack(PlantMegaPack.objects.getItem(TypePlantRoot.getRootItemFromID(this.defPlant.rootID)), 1, 0));
        }
        if (ret.isEmpty()) {
            ret.add(new ItemStack(PlantMegaPack.objects.getPlant(this.defPlant), 1, 0));
        }
        return ret;
    }

    private boolean canPlantBeBrokenIntoParts() {
        return this.defPlant.flowerID >= 0 || this.defPlant.stemID >= 0 || this.defPlant.rootID >= 0;
    }
}

