/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.storage.sqllte;

import java.io.File;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.PlayerFaces;
import org.dynmap.WebAuthManager;
import org.dynmap.storage.MapStorage;
import org.dynmap.storage.MapStorageBaseTileEnumCB;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.storage.MapStorageTileEnumCB;
import org.dynmap.storage.MapStorageTileSearchEndCB;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;

public class SQLiteMapStorage
extends MapStorage {
    private String connectionString;
    private String databaseFile;
    private static final int POOLSIZE = 5;
    private Connection[] cpool = new Connection[5];
    private int cpoolCount = 0;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private HashMap<String, Integer> mapKey = new HashMap();

    @Override
    public boolean init(DynmapCore core) {
        if (!super.init(core)) {
            return false;
        }
        File dbfile = core.getFile(core.configuration.getString("storage/dbfile", "dynmap.db"));
        this.databaseFile = dbfile.getAbsolutePath();
        this.connectionString = "jdbc:sqlite:" + this.databaseFile;
        Log.info("Opening SQLite file " + this.databaseFile + " as map store");
        try {
            Class.forName("org.sqlite.JDBC");
            return this.initializeTables();
        }
        catch (ClassNotFoundException cnfx) {
            Log.severe("SQLite-JDBC classes not found - sqlite data source not usable");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSchemaVersion() {
        int ver = 0;
        boolean err = false;
        Connection c = null;
        try {
            c = this.getConnection();
            Statement stmt = c.createStatement();
            ResultSet rs = this.doExecuteQuery(stmt, "SELECT level FROM SchemaVersion;");
            if (rs.next()) {
                ver = rs.getInt("level");
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException x) {
            err = true;
        }
        finally {
            if (c != null) {
                this.releaseConnection(c, err);
            }
        }
        return ver;
    }

    private void doUpdate(Connection c, String sql) throws SQLException {
        Statement stmt = c.createStatement();
        this.doExecuteUpdate(stmt, sql);
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadMaps() {
        Connection c = null;
        boolean err = false;
        this.mapKey.clear();
        try {
            c = this.getConnection();
            Statement stmt = c.createStatement();
            ResultSet rs = this.doExecuteQuery(stmt, "SELECT * from Maps;");
            while (rs.next()) {
                int key = rs.getInt("ID");
                String worldID = rs.getString("WorldID");
                String mapID = rs.getString("MapID");
                String variant = rs.getString("Variant");
                this.mapKey.put(worldID + ":" + mapID + ":" + variant, key);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException x) {
            Log.severe("Error loading map table - " + x.getMessage());
            err = true;
        }
        finally {
            this.releaseConnection(c, err);
            c = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getMapKey(DynmapWorld w, MapType mt, MapType.ImageVariant var) {
        String id = w.getName() + ":" + mt.getPrefix() + ":" + var.toString();
        HashMap<String, Integer> hashMap = this.mapKey;
        synchronized (hashMap) {
            Integer k = this.mapKey.get(id);
            if (k == null) {
                Connection c = null;
                boolean err = false;
                try {
                    c = this.getConnection();
                    PreparedStatement stmt = c.prepareStatement("INSERT INTO Maps (WorldID,MapID,Variant) VALUES (?, ?, ?);");
                    stmt.setString(1, w.getName());
                    stmt.setString(2, mt.getPrefix());
                    stmt.setString(3, var.toString());
                    this.doExecuteUpdate(stmt);
                    stmt.close();
                    stmt = c.prepareStatement("SELECT ID FROM Maps WHERE WorldID = ? AND MapID = ? AND Variant = ?;");
                    stmt.setString(1, w.getName());
                    stmt.setString(2, mt.getPrefix());
                    stmt.setString(3, var.toString());
                    ResultSet rs = this.doExecuteQuery(stmt);
                    if (rs.next()) {
                        k = rs.getInt("ID");
                        this.mapKey.put(id, k);
                    }
                    rs.close();
                    stmt.close();
                }
                catch (SQLException x) {
                    Log.severe("Error updating Maps table - " + x.getMessage());
                    err = true;
                }
                finally {
                    this.releaseConnection(c, err);
                }
            }
            return k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeTables() {
        Connection c = null;
        boolean err = false;
        int version = this.getSchemaVersion();
        if (version == 0) {
            try {
                c = this.getConnection();
                this.doUpdate(c, "CREATE TABLE Maps (ID INTEGER PRIMARY KEY AUTOINCREMENT, WorldID STRING NOT NULL, MapID STRING NOT NULL, Variant STRING NOT NULL)");
                this.doUpdate(c, "CREATE TABLE Tiles (MapID INT NOT NULL, x INT NOT NULL, y INT NOT NULL, zoom INT NOT NULL, HashCode INT NOT NULL, LastUpdate INT NOT NULL, Format INT NOT NULL, Image BLOB, ImageLen INT, PRIMARY KEY(MapID, x, y, zoom))");
                this.doUpdate(c, "CREATE TABLE Faces (PlayerName STRING NOT NULL, TypeID INT NOT NULL, Image BLOB, ImageLen INT, PRIMARY KEY(PlayerName, TypeID))");
                this.doUpdate(c, "CREATE TABLE MarkerIcons (IconName STRING PRIMARY KEY NOT NULL, Image BLOB, ImageLen INT)");
                this.doUpdate(c, "CREATE TABLE MarkerFiles (FileName STRING PRIMARY KEY NOT NULL, Content CLOB)");
                this.doUpdate(c, "CREATE TABLE SchemaVersion (level INT PRIMARY KEY NOT NULL)");
                this.doUpdate(c, "INSERT INTO SchemaVersion (level) VALUES (2)");
            }
            catch (SQLException x) {
                Log.severe("Error creating tables - " + x.getMessage());
                err = true;
                boolean bl = false;
                return bl;
            }
            finally {
                this.releaseConnection(c, err);
                c = null;
            }
        }
        if (version == 1) {
            try {
                c = this.getConnection();
                this.doUpdate(c, "ALTER TABLE Tiles ADD ImageLen INT");
                this.doUpdate(c, "ALTER TABLE Faces ADD ImageLen INT");
                this.doUpdate(c, "ALTER TABLE MarkerIcons ADD ImageLen INT");
                this.doUpdate(c, "UPDATE SchemaVersion SET level=2");
            }
            catch (SQLException x) {
                Log.severe("Error creating tables - " + x.getMessage());
                err = true;
                boolean bl = false;
                return bl;
            }
            finally {
                this.releaseConnection(c, err);
                c = null;
            }
        }
        this.doLoadMaps();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws SQLException {
        Connection c = null;
        Connection[] connectionArray = this.cpool;
        synchronized (this.cpool) {
            while (c == null) {
                for (int i = 0; i < this.cpool.length; ++i) {
                    if (this.cpool[i] == null) continue;
                    c = this.cpool[i];
                    this.cpool[i] = null;
                }
                if (c != null) continue;
                if (this.cpoolCount < 5) {
                    c = DriverManager.getConnection(this.connectionString);
                    SQLiteMapStorage.configureConnection(c);
                    ++this.cpoolCount;
                    continue;
                }
                try {
                    this.cpool.wait();
                }
                catch (InterruptedException e) {
                    throw new SQLException("Interruped");
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return c;
        }
    }

    private static Connection configureConnection(Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute("PRAGMA journal_mode = WAL;");
        statement.close();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(Connection c, boolean err) {
        if (c == null) {
            return;
        }
        Connection[] connectionArray = this.cpool;
        synchronized (this.cpool) {
            if (!err) {
                for (int i = 0; i < 5; ++i) {
                    if (this.cpool[i] != null) continue;
                    this.cpool[i] = c;
                    c = null;
                    this.cpool.notifyAll();
                    break;
                }
            }
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                --this.cpoolCount;
                this.cpool.notifyAll();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public MapStorageTile getTile(DynmapWorld world, MapType map, int x, int y, int zoom, MapType.ImageVariant var) {
        return new StorageTile(world, map, x, y, zoom, var);
    }

    @Override
    public MapStorageTile getTile(DynmapWorld world, String uri) {
        String[] suri = uri.split("/");
        if (suri.length < 2) {
            return null;
        }
        String mname = suri[0];
        MapType mt = null;
        MapType.ImageVariant imgvar = null;
        for (int mti = 0; mt == null && mti < world.maps.size(); ++mti) {
            MapType type = world.maps.get(mti);
            MapType.ImageVariant[] var = type.getVariants();
            for (int ivi = 0; imgvar == null && ivi < var.length; ++ivi) {
                if (!mname.equals(type.getPrefix() + var[ivi].variantSuffix)) continue;
                mt = type;
                imgvar = var[ivi];
            }
        }
        if (mt == null) {
            return null;
        }
        String fname = suri[suri.length - 1];
        String[] coord = fname.split("[_\\.]");
        if (coord.length < 3) {
            return null;
        }
        int zoom = 0;
        try {
            int y;
            int x;
            if (coord[0].charAt(0) == 'z') {
                zoom = coord[0].length();
                x = Integer.parseInt(coord[1]);
                y = Integer.parseInt(coord[2]);
            } else {
                x = Integer.parseInt(coord[0]);
                y = Integer.parseInt(coord[1]);
            }
            return this.getTile(world, mt, x, y, zoom, imgvar);
        }
        catch (NumberFormatException nfx) {
            return null;
        }
    }

    @Override
    public void enumMapTiles(DynmapWorld world, MapType map, MapStorageTileEnumCB cb) {
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processEnumMapTiles(world, mt, var, cb, null, null);
            }
        }
    }

    @Override
    public void enumMapBaseTiles(DynmapWorld world, MapType map, MapStorageBaseTileEnumCB cbBase, MapStorageTileSearchEndCB cbEnd) {
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processEnumMapTiles(world, mt, var, null, cbBase, cbEnd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEnumMapTiles(DynmapWorld world, MapType map, MapType.ImageVariant var, MapStorageTileEnumCB cb, MapStorageBaseTileEnumCB cbBase, MapStorageTileSearchEndCB cbEnd) {
        Connection c = null;
        boolean err = false;
        Integer mapkey = this.getMapKey(world, map, var);
        if (mapkey == null) {
            if (cbEnd != null) {
                cbEnd.searchEnded();
            }
            return;
        }
        try {
            c = this.getConnection();
            Statement stmt = c.createStatement();
            ResultSet rs = this.doExecuteQuery(stmt, "SELECT x,y,zoom,Format FROM Tiles WHERE MapID=" + mapkey + ";");
            while (rs.next()) {
                StorageTile st = new StorageTile(world, map, rs.getInt("x"), rs.getInt("y"), rs.getInt("zoom"), var);
                MapType.ImageEncoding encoding = MapType.ImageEncoding.fromOrd(rs.getInt("Format"));
                if (cb != null) {
                    cb.tileFound(st, encoding);
                }
                if (cbBase != null && st.zoom == 0) {
                    cbBase.tileFound(st, encoding);
                }
                st.cleanup();
            }
            if (cbEnd != null) {
                cbEnd.searchEnded();
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException x) {
            Log.severe("Tile enum error - " + x.getMessage());
            err = true;
        }
        finally {
            this.releaseConnection(c, err);
        }
    }

    @Override
    public void purgeMapTiles(DynmapWorld world, MapType map) {
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processPurgeMapTiles(world, mt, var);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPurgeMapTiles(DynmapWorld world, MapType map, MapType.ImageVariant var) {
        Connection c = null;
        boolean err = false;
        Integer mapkey = this.getMapKey(world, map, var);
        if (mapkey == null) {
            return;
        }
        try {
            c = this.getConnection();
            Statement stmt = c.createStatement();
            this.doExecuteUpdate(stmt, "DELETE FROM Tiles WHERE MapID=" + mapkey + ";");
            stmt.close();
        }
        catch (SQLException x) {
            Log.severe("Tile purge error - " + x.getMessage());
            err = true;
        }
        finally {
            this.releaseConnection(c, err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPlayerFaceImage(String playername, PlayerFaces.FaceType facetype, BufferOutputStream encImage) {
        Connection c = null;
        boolean err = false;
        boolean exists = this.hasPlayerFaceImage(playername, facetype);
        if (encImage == null && !exists) {
            return false;
        }
        try {
            PreparedStatement stmt;
            c = this.getConnection();
            if (encImage == null) {
                stmt = c.prepareStatement("DELETE FROM Faces WHERE PlayerName=? AND TypeIDx=?;");
                stmt.setString(1, playername);
                stmt.setInt(2, facetype.typeID);
            } else if (exists) {
                stmt = c.prepareStatement("UPDATE Faces SET Image=?,ImageLen=? WHERE PlayerName=? AND TypeID=?;");
                stmt.setBytes(1, encImage.buf);
                stmt.setInt(2, encImage.len);
                stmt.setString(3, playername);
                stmt.setInt(4, facetype.typeID);
            } else {
                stmt = c.prepareStatement("INSERT INTO Faces (PlayerName,TypeID,Image,ImageLen) VALUES (?,?,?,?);");
                stmt.setString(1, playername);
                stmt.setInt(2, facetype.typeID);
                stmt.setBytes(3, encImage.buf);
                stmt.setInt(4, encImage.len);
            }
            this.doExecuteUpdate(stmt);
            stmt.close();
        }
        catch (SQLException x) {
            Log.severe("Face write error - " + x.getMessage());
            err = true;
        }
        finally {
            this.releaseConnection(c, err);
        }
        return !err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferInputStream getPlayerFaceImage(String playername, PlayerFaces.FaceType facetype) {
        Connection c = null;
        boolean err = false;
        BufferInputStream image = null;
        try {
            c = this.getConnection();
            PreparedStatement stmt = c.prepareStatement("SELECT Image,ImageLen FROM Faces WHERE PlayerName=? AND TypeID=?;");
            stmt.setString(1, playername);
            stmt.setInt(2, facetype.typeID);
            ResultSet rs = this.doExecuteQuery(stmt);
            if (rs.next()) {
                byte[] img = rs.getBytes("Image");
                int len = rs.getInt("imageLen");
                if (len <= 0) {
                    for (len = img.length; len > 0 && img[len - 1] == 0; --len) {
                    }
                }
                image = new BufferInputStream(img, len);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException x) {
            Log.severe("Face read error - " + x.getMessage());
            err = true;
        }
        finally {
            this.releaseConnection(c, err);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPlayerFaceImage(String playername, PlayerFaces.FaceType facetype) {
        Connection c = null;
        boolean err = false;
        boolean exists = false;
        try {
            c = this.getConnection();
            PreparedStatement stmt = c.prepareStatement("SELECT TypeID FROM Faces WHERE PlayerName=? AND TypeID=?;");
            stmt.setString(1, playername);
            stmt.setInt(2, facetype.typeID);
            ResultSet rs = this.doExecuteQuery(stmt);
            if (rs.next()) {
                exists = true;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException x) {
            Log.severe("Face exists error - " + x.getMessage());
            err = true;
        }
        finally {
            this.releaseConnection(c, err);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMarkerImage(String markerid, BufferOutputStream encImage) {
        Connection c = null;
        boolean err = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            c = this.getConnection();
            boolean exists = false;
            stmt = c.prepareStatement("SELECT IconName FROM MarkerIcons WHERE IconName=?;");
            stmt.setString(1, markerid);
            rs = this.doExecuteQuery(stmt);
            if (rs.next()) {
                exists = true;
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            if (encImage == null) {
                if (!exists) {
                    boolean bl = false;
                    return bl;
                }
                stmt = c.prepareStatement("DELETE FROM MarkerIcons WHERE IconName=?;");
                stmt.setString(1, markerid);
                this.doExecuteUpdate(stmt);
            } else if (exists) {
                stmt = c.prepareStatement("UPDATE MarkerIcons SET Image=?,ImageLen=? WHERE IconName=?;");
                stmt.setBytes(1, encImage.buf);
                stmt.setInt(2, encImage.len);
                stmt.setString(3, markerid);
            } else {
                stmt = c.prepareStatement("INSERT INTO MarkerIcons (IconName,Image,ImageLen) VALUES (?,?,?);");
                stmt.setString(1, markerid);
                stmt.setBytes(2, encImage.buf);
                stmt.setInt(3, encImage.len);
            }
            this.doExecuteUpdate(stmt);
            stmt.close();
            stmt = null;
        }
        catch (SQLException x) {
            Log.severe("Marker write error - " + x.getMessage());
            err = true;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            this.releaseConnection(c, err);
        }
        return !err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferInputStream getMarkerImage(String markerid) {
        Connection c = null;
        boolean err = false;
        BufferInputStream image = null;
        try {
            c = this.getConnection();
            PreparedStatement stmt = c.prepareStatement("SELECT Image,ImageLen FROM MarkerIcons WHERE IconName=?;");
            stmt.setString(1, markerid);
            ResultSet rs = this.doExecuteQuery(stmt);
            if (rs.next()) {
                byte[] img = rs.getBytes("Image");
                int len = rs.getInt("ImageLen");
                if (len <= 0) {
                    for (len = img.length; len > 0 && img[len - 1] == 0; --len) {
                    }
                }
                image = new BufferInputStream(img);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException x) {
            Log.severe("Marker read error - " + x.getMessage());
            err = true;
        }
        finally {
            this.releaseConnection(c, err);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMarkerFile(String world, String content) {
        Connection c = null;
        boolean err = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            c = this.getConnection();
            boolean exists = false;
            stmt = c.prepareStatement("SELECT FileName FROM MarkerFiles WHERE FileName=?;");
            stmt.setString(1, world);
            rs = this.doExecuteQuery(stmt);
            if (rs.next()) {
                exists = true;
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            if (content == null) {
                if (!exists) {
                    boolean bl = false;
                    return bl;
                }
                stmt = c.prepareStatement("DELETE FROM MarkerFiles WHERE FileName=?;");
                stmt.setString(1, world);
                this.doExecuteUpdate(stmt);
            } else if (exists) {
                stmt = c.prepareStatement("UPDATE MarkerFiles SET Content=? WHERE FileName=?;");
                stmt.setBytes(1, content.getBytes(UTF8));
                stmt.setString(2, world);
            } else {
                stmt = c.prepareStatement("INSERT INTO MarkerFiles (FileName,Content) VALUES (?,?);");
                stmt.setString(1, world);
                stmt.setBytes(2, content.getBytes(UTF8));
            }
            this.doExecuteUpdate(stmt);
        }
        catch (SQLException x) {
            Log.severe("Marker file write error - " + x.getMessage());
            err = true;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            this.releaseConnection(c, err);
        }
        return !err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMarkerFile(String world) {
        Connection c = null;
        boolean err = false;
        String content = null;
        try {
            c = this.getConnection();
            PreparedStatement stmt = c.prepareStatement("SELECT Content FROM MarkerFiles WHERE FileName=?;");
            stmt.setString(1, world);
            ResultSet rs = this.doExecuteQuery(stmt);
            if (rs.next()) {
                byte[] img = rs.getBytes("Content");
                content = new String(img, UTF8);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException x) {
            Log.severe("Marker file read error - " + x.getMessage());
            err = true;
        }
        finally {
            this.releaseConnection(c, err);
        }
        return content;
    }

    @Override
    public String getMarkersURI(boolean login_enabled) {
        return "standalone/SQLite_markers.php?marker=";
    }

    @Override
    public String getTilesURI(boolean login_enabled) {
        return "standalone/SQLite_tiles.php?tile=";
    }

    @Override
    public void addPaths(StringBuilder sb, DynmapCore core) {
        sb.append("$dbfile = '");
        sb.append(WebAuthManager.esc(this.databaseFile));
        sb.append("';\n");
        super.addPaths(sb, core);
    }

    private ResultSet doExecuteQuery(PreparedStatement statement) throws SQLException {
        while (true) {
            try {
                return statement.executeQuery();
            }
            catch (SQLException x) {
                if (x.getMessage().contains("[SQLITE_BUSY]")) continue;
                throw x;
            }
            break;
        }
    }

    private ResultSet doExecuteQuery(Statement statement, String sql) throws SQLException {
        while (true) {
            try {
                return statement.executeQuery(sql);
            }
            catch (SQLException x) {
                if (x.getMessage().contains("[SQLITE_BUSY]")) continue;
                throw x;
            }
            break;
        }
    }

    private int doExecuteUpdate(PreparedStatement statement) throws SQLException {
        while (true) {
            try {
                return statement.executeUpdate();
            }
            catch (SQLException x) {
                if (x.getMessage().contains("[SQLITE_BUSY]")) continue;
                throw x;
            }
            break;
        }
    }

    private int doExecuteUpdate(Statement statement, String sql) throws SQLException {
        while (true) {
            try {
                return statement.executeUpdate(sql);
            }
            catch (SQLException x) {
                if (x.getMessage().contains("[SQLITE_BUSY]")) continue;
                throw x;
            }
            break;
        }
    }

    public class StorageTile
    extends MapStorageTile {
        private Integer mapkey;
        private String uri;

        protected StorageTile(DynmapWorld world, MapType map, int x, int y, int zoom, MapType.ImageVariant var) {
            super(world, map, x, y, zoom, var);
            this.mapkey = SQLiteMapStorage.this.getMapKey(world, map, var);
            this.uri = zoom > 0 ? map.getPrefix() + var.variantSuffix + "/" + (x >> 5) + "_" + (y >> 5) + "/" + "zzzzzzzzzzzzzzzz".substring(0, zoom) + "_" + x + "_" + y + "." + map.getImageFormat().getFileExt() : map.getPrefix() + var.variantSuffix + "/" + (x >> 5) + "_" + (y >> 5) + "/" + x + "_" + y + "." + map.getImageFormat().getFileExt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean exists() {
            if (this.mapkey == null) {
                return false;
            }
            boolean rslt = false;
            Connection c = null;
            boolean err = false;
            try {
                c = SQLiteMapStorage.this.getConnection();
                Statement stmt = c.createStatement();
                ResultSet rs = SQLiteMapStorage.this.doExecuteQuery(stmt, "SELECT HashCode FROM Tiles WHERE MapID=" + this.mapkey + " AND x=" + this.x + " AND y=" + this.y + " AND zoom=" + this.zoom + ";");
                rslt = rs.next();
                rs.close();
                stmt.close();
            }
            catch (SQLException x) {
                Log.severe("Tile exists error - " + x.getMessage());
                err = true;
            }
            finally {
                SQLiteMapStorage.this.releaseConnection(c, err);
            }
            return rslt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matchesHashCode(long hash) {
            if (this.mapkey == null) {
                return false;
            }
            boolean rslt = false;
            Connection c = null;
            boolean err = false;
            try {
                c = SQLiteMapStorage.this.getConnection();
                Statement stmt = c.createStatement();
                ResultSet rs = SQLiteMapStorage.this.doExecuteQuery(stmt, "SELECT HashCode FROM Tiles WHERE MapID=" + this.mapkey + " AND x=" + this.x + " AND y=" + this.y + " AND zoom=" + this.zoom + ";");
                if (rs.next()) {
                    long v = rs.getLong("HashCode");
                    rslt = v == hash;
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException x) {
                Log.severe("Tile matches hash error - " + x.getMessage());
                err = true;
            }
            finally {
                SQLiteMapStorage.this.releaseConnection(c, err);
            }
            return rslt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MapStorageTile.TileRead read() {
            if (this.mapkey == null) {
                return null;
            }
            MapStorageTile.TileRead rslt = null;
            Connection c = null;
            boolean err = false;
            try {
                c = SQLiteMapStorage.this.getConnection();
                Statement stmt = c.createStatement();
                ResultSet rs = SQLiteMapStorage.this.doExecuteQuery(stmt, "SELECT HashCode,LastUpdate,Format,Image,ImageLen FROM Tiles WHERE MapID=" + this.mapkey + " AND x=" + this.x + " AND y=" + this.y + " AND zoom=" + this.zoom + ";");
                if (rs.next()) {
                    rslt = new MapStorageTile.TileRead();
                    rslt.hashCode = rs.getLong("HashCode");
                    rslt.lastModified = rs.getLong("LastUpdate");
                    rslt.format = MapType.ImageEncoding.fromOrd(rs.getInt("Format"));
                    byte[] img = rs.getBytes("Image");
                    int len = rs.getInt("ImageLen");
                    if (len <= 0) {
                        for (len = img.length; len > 0 && img[len - 1] == 0; --len) {
                        }
                    }
                    rslt.image = new BufferInputStream(img, len);
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException x) {
                Log.severe("Tile read error - " + x.getMessage());
                err = true;
            }
            finally {
                SQLiteMapStorage.this.releaseConnection(c, err);
            }
            return rslt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean write(long hash, BufferOutputStream encImage) {
            if (this.mapkey == null) {
                return false;
            }
            Connection c = null;
            boolean err = false;
            boolean exists = this.exists();
            if (encImage == null && !exists) {
                return false;
            }
            try {
                PreparedStatement stmt;
                c = SQLiteMapStorage.this.getConnection();
                if (encImage == null) {
                    stmt = c.prepareStatement("DELETE FROM Tiles WHERE MapID=? AND x=? and y=? AND zoom=?;");
                    stmt.setInt(1, this.mapkey);
                    stmt.setInt(2, this.x);
                    stmt.setInt(3, this.y);
                    stmt.setInt(4, this.zoom);
                } else if (exists) {
                    stmt = c.prepareStatement("UPDATE Tiles SET HashCode=?, LastUpdate=?, Format=?, Image=?, ImageLen=? WHERE MapID=? AND x=? and y=? AND zoom=?;");
                    stmt.setLong(1, hash);
                    stmt.setLong(2, System.currentTimeMillis());
                    stmt.setInt(3, this.map.getImageFormat().getEncoding().ordinal());
                    stmt.setBytes(4, encImage.buf);
                    stmt.setInt(5, encImage.len);
                    stmt.setInt(6, this.mapkey);
                    stmt.setInt(7, this.x);
                    stmt.setInt(8, this.y);
                    stmt.setInt(9, this.zoom);
                } else {
                    stmt = c.prepareStatement("INSERT INTO Tiles (MapID,x,y,zoom,HashCode,LastUpdate,Format,Image,ImageLen) VALUES (?,?,?,?,?,?,?,?,?);");
                    stmt.setInt(1, this.mapkey);
                    stmt.setInt(2, this.x);
                    stmt.setInt(3, this.y);
                    stmt.setInt(4, this.zoom);
                    stmt.setLong(5, hash);
                    stmt.setLong(6, System.currentTimeMillis());
                    stmt.setInt(7, this.map.getImageFormat().getEncoding().ordinal());
                    stmt.setBytes(8, encImage.buf);
                    stmt.setInt(9, encImage.len);
                }
                SQLiteMapStorage.this.doExecuteUpdate(stmt);
                stmt.close();
                if (this.zoom == 0) {
                    this.world.enqueueZoomOutUpdate(this);
                }
            }
            catch (SQLException x) {
                Log.severe("Tile write error - " + x.getMessage());
                err = true;
            }
            finally {
                SQLiteMapStorage.this.releaseConnection(c, err);
            }
            return !err;
        }

        @Override
        public boolean getWriteLock() {
            return SQLiteMapStorage.this.getWriteLock(this.uri);
        }

        @Override
        public void releaseWriteLock() {
            SQLiteMapStorage.this.releaseWriteLock(this.uri);
        }

        @Override
        public boolean getReadLock(long timeout) {
            return SQLiteMapStorage.this.getReadLock(this.uri, timeout);
        }

        @Override
        public void releaseReadLock() {
            SQLiteMapStorage.this.releaseReadLock(this.uri);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        @Override
        public void enqueueZoomOutUpdate() {
            this.world.enqueueZoomOutUpdate(this);
        }

        @Override
        public MapStorageTile getZoomOutTile() {
            int step = 1 << this.zoom;
            int xx = this.x >= 0 ? this.x - this.x % (2 * step) : this.x + this.x % (2 * step);
            int yy = -this.y;
            yy = yy >= 0 ? (yy -= yy % (2 * step)) : (yy += yy % (2 * step));
            yy = -yy;
            return new StorageTile(this.world, this.map, xx, yy, this.zoom + 1, this.var);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof StorageTile) {
                StorageTile st = (StorageTile)o;
                return this.uri.equals(st.uri);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.uri.hashCode();
        }
    }
}

