/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dynmap.javax.servlet.ServletException;
import org.dynmap.javax.servlet.ServletRequest;
import org.dynmap.javax.servlet.ServletResponse;
import org.dynmap.javax.servlet.http.HttpServlet;
import org.dynmap.javax.servlet.http.HttpServletRequest;
import org.dynmap.javax.servlet.http.HttpServletRequestWrapper;
import org.dynmap.javax.servlet.http.HttpServletResponse;

public class MainServlet
extends HttpServlet {
    List<Registration> registrations = new LinkedList<Registration>();
    public List<Header> customHeaders = new LinkedList<Header>();

    public void addServlet(String pattern, HttpServlet servlet) {
        this.registrations.add(new Registration(pattern, servlet));
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String path = req.getPathInfo();
        for (Header header : this.customHeaders) {
            resp.setHeader(header.name, header.value);
        }
        Registration bestMatch = null;
        String bestMatchPart = null;
        HashMap<String, Object> bestProperties = null;
        for (Registration r : this.registrations) {
            String matchingPart = this.match(r.pattern, path, properties);
            if (matchingPart == null || bestMatchPart != null && bestMatchPart.length() >= matchingPart.length()) continue;
            bestMatch = r;
            bestMatchPart = matchingPart;
            bestProperties = properties;
            properties = new HashMap();
        }
        if (bestMatch == null) {
            resp.sendError(404);
        } else {
            String leftOverPath = path.substring(bestMatchPart.length());
            RequestWrapper newreq = new RequestWrapper(req, leftOverPath);
            for (String key : bestProperties.keySet()) {
                newreq.setAttribute(key, bestProperties.get(key));
            }
            bestMatch.servlet.service((ServletRequest)newreq, (ServletResponse)resp);
        }
    }

    public String match(String pattern, String path, Map<String, Object> properties) {
        int patternStart = 0;
        int pathStart = 0;
        while (patternStart < pattern.length()) {
            String literal;
            int endOfPathLiteral;
            if (pattern.charAt(patternStart) == '{') {
                int endOfVariable = pattern.indexOf(125, patternStart + 1);
                String variableName = pattern.substring(patternStart + 1, endOfVariable);
                int endOfSection = this.indexOfAny(path, new char[]{'/', '?'}, pathStart);
                if (endOfSection < 0) {
                    endOfSection = path.length();
                }
                String variableValue = path.substring(pathStart, endOfSection);
                properties.put(variableName, variableValue);
                patternStart = endOfVariable + 1;
                pathStart = endOfSection;
                continue;
            }
            int endOfLiteral = pattern.indexOf(123, patternStart);
            if (endOfLiteral < 0) {
                endOfLiteral = pattern.length();
            }
            if ((endOfPathLiteral = pathStart + (literal = pattern.substring(patternStart, endOfLiteral)).length()) > path.length()) {
                return null;
            }
            String matchingLiteral = path.substring(pathStart, endOfPathLiteral);
            if (!literal.equals(matchingLiteral)) {
                return null;
            }
            patternStart = endOfLiteral;
            pathStart = endOfPathLiteral;
        }
        return path.substring(0, pathStart);
    }

    private int indexOfAny(String s, char[] cs, int startIndex) {
        for (int i = startIndex; i < s.length(); ++i) {
            char c = s.charAt(i);
            for (int j = 0; j < cs.length; ++j) {
                if (c != cs[j]) continue;
                return i;
            }
        }
        return -1;
    }

    class RequestWrapper
    extends HttpServletRequestWrapper {
        String pathInfo;

        public RequestWrapper(HttpServletRequest request, String pathInfo) {
            super(request);
            this.pathInfo = pathInfo;
        }

        @Override
        public String getPathInfo() {
            return this.pathInfo;
        }
    }

    private static class Registration {
        public String pattern;
        public HttpServlet servlet;

        public Registration(String pattern, HttpServlet servlet) {
            this.pattern = pattern;
            this.servlet = servlet;
        }
    }

    public static class Header {
        public String name;
        public String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

