/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.servlet;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dynmap.Client;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.InternalClientUpdateComponent;
import org.dynmap.JSONUtils;
import org.dynmap.javax.servlet.ServletException;
import org.dynmap.javax.servlet.http.HttpServlet;
import org.dynmap.javax.servlet.http.HttpServletRequest;
import org.dynmap.javax.servlet.http.HttpServletResponse;
import org.dynmap.javax.servlet.http.HttpSession;
import org.dynmap.json.simple.JSONArray;
import org.dynmap.json.simple.JSONObject;

public class ClientUpdateServlet
extends HttpServlet {
    private DynmapCore core;
    private Charset cs_utf8 = Charset.forName("UTF-8");
    Pattern updatePathPattern = Pattern.compile("/([^/]+)/([0-9]*)");

    public ClientUpdateServlet(DynmapCore plugin) {
        this.core = plugin;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        byte[] bytes;
        HttpSession sess = req.getSession(true);
        String user = (String)sess.getAttribute("userid");
        if (user == null) {
            user = "_guest_";
        }
        boolean guest = user.equals("_guest_");
        if (this.core.getLoginRequired() && guest) {
            JSONObject json = new JSONObject();
            JSONUtils.s(json, "error", "login-required");
            bytes = json.toJSONString().getBytes(this.cs_utf8);
        } else {
            ListIterator iter;
            String path = req.getPathInfo();
            Matcher match = this.updatePathPattern.matcher(path);
            if (!match.matches()) {
                resp.sendError(404, "World not found");
                return;
            }
            String worldName = match.group(1);
            String timeKey = match.group(2);
            DynmapWorld dynmapWorld = null;
            if (this.core.mapManager != null) {
                dynmapWorld = this.core.mapManager.getWorld(worldName);
            }
            if (dynmapWorld == null) {
                resp.sendError(404, "World not found");
                return;
            }
            long since = 0L;
            try {
                since = Long.parseLong(timeKey);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            JSONObject u = new JSONObject();
            JSONObject upd = InternalClientUpdateComponent.getWorldUpdate(dynmapWorld.getName());
            if (upd != null) {
                u.putAll(upd);
            }
            boolean see_all = true;
            if (this.core.player_info_protected) {
                see_all = guest ? false : this.core.getServer().checkPlayerPermission(user, "playermarkers.seeall");
            }
            if (!see_all) {
                JSONArray players = (JSONArray)JSONUtils.g(u, "players");
                JSONArray newplayers = new JSONArray();
                u.put("players", newplayers);
                if (players != null) {
                    iter = players.listIterator();
                    while (iter.hasNext()) {
                        JSONObject p = (JSONObject)iter.next();
                        JSONObject newp = new JSONObject();
                        newp.putAll(p);
                        newplayers.add(newp);
                        boolean hide = !guest ? !this.core.testIfPlayerVisibleToPlayer(user, (String)newp.get("name")) : true;
                        if (!hide) continue;
                        JSONUtils.s(newp, "world", "-some-other-bogus-world-");
                        JSONUtils.s(newp, "x", 0.0);
                        JSONUtils.s(newp, "y", 64.0);
                        JSONUtils.s(newp, "z", 0.0);
                        JSONUtils.s(newp, "health", 0);
                        JSONUtils.s(newp, "armor", 0);
                    }
                }
            }
            JSONArray updates = (JSONArray)u.get("updates");
            JSONArray newupdates = new JSONArray();
            u.put("updates", newupdates);
            if (updates != null) {
                iter = updates.listIterator();
                while (iter.hasNext()) {
                    Client.Update update = (Client.Update)iter.next();
                    if (update.timestamp < since) continue;
                    newupdates.add(update);
                }
            }
            bytes = u.toJSONString().getBytes(this.cs_utf8);
        }
        String dateStr = new Date().toString();
        resp.addHeader("Date", dateStr);
        resp.addHeader("Content-Type", "text/plain; charset=utf-8");
        resp.addHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        resp.addHeader("Last-Modified", dateStr);
        resp.addHeader("Content-Length", Integer.toString(bytes.length));
        resp.getOutputStream().write(bytes);
    }
}

