/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.CircleMarker;
import org.dynmap.markers.EnterExitMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PolyLineMarker;
import org.dynmap.markers.impl.AreaMarkerImpl;
import org.dynmap.markers.impl.CircleMarkerImpl;
import org.dynmap.markers.impl.MarkerAPIImpl;
import org.dynmap.markers.impl.MarkerIconImpl;
import org.dynmap.markers.impl.MarkerImpl;
import org.dynmap.markers.impl.PolyLineMarkerImpl;

class MarkerSetImpl
implements MarkerSet {
    private ConcurrentHashMap<String, MarkerImpl> markers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AreaMarkerImpl> areamarkers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, PolyLineMarkerImpl> linemarkers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CircleMarkerImpl> circlemarkers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AreaMarkerImpl> boostingareamarkers = null;
    private ConcurrentHashMap<String, CircleMarkerImpl> boostingcirclemarkers = null;
    private ConcurrentHashMap<String, EnterExitMarker> enterexitmarkers = null;
    private String setid;
    private String label;
    private ConcurrentHashMap<String, MarkerIconImpl> allowedicons = null;
    private boolean hide_by_def;
    private boolean ispersistent;
    private int prio = 0;
    private int minzoom = -1;
    private int maxzoom = -1;
    private Boolean showlabels = null;
    private MarkerIcon deficon;

    MarkerSetImpl(String id) {
        this.setid = id;
        this.label = id;
        this.deficon = MarkerAPIImpl.getMarkerIconImpl("default");
    }

    MarkerSetImpl(String id, String lbl, Set<MarkerIcon> iconlimit, boolean persistent) {
        this.setid = id;
        this.label = lbl != null ? lbl : id;
        if (iconlimit != null) {
            this.allowedicons = new ConcurrentHashMap();
            for (MarkerIcon ico : iconlimit) {
                if (!(ico instanceof MarkerIconImpl)) continue;
                this.allowedicons.put(ico.getMarkerIconID(), (MarkerIconImpl)ico);
            }
        }
        this.ispersistent = persistent;
        this.deficon = MarkerAPIImpl.getMarkerIconImpl("default");
    }

    void cleanup() {
        for (MarkerImpl markerImpl : this.markers.values()) {
            markerImpl.cleanup();
        }
        for (AreaMarkerImpl areaMarkerImpl : this.areamarkers.values()) {
            areaMarkerImpl.cleanup();
        }
        for (PolyLineMarkerImpl polyLineMarkerImpl : this.linemarkers.values()) {
            polyLineMarkerImpl.cleanup();
        }
        for (CircleMarkerImpl circleMarkerImpl : this.circlemarkers.values()) {
            circleMarkerImpl.cleanup();
        }
        this.markers.clear();
        if (this.boostingareamarkers != null) {
            this.boostingareamarkers.clear();
            this.boostingareamarkers = null;
        }
        if (this.boostingcirclemarkers != null) {
            this.boostingcirclemarkers.clear();
            this.boostingcirclemarkers = null;
        }
        if (this.enterexitmarkers != null) {
            this.enterexitmarkers.clear();
            this.enterexitmarkers = null;
        }
        this.deficon = null;
    }

    @Override
    public Set<Marker> getMarkers() {
        return new HashSet<Marker>(this.markers.values());
    }

    @Override
    public Set<AreaMarker> getAreaMarkers() {
        return new HashSet<AreaMarker>(this.areamarkers.values());
    }

    @Override
    public Set<PolyLineMarker> getPolyLineMarkers() {
        return new HashSet<PolyLineMarker>(this.linemarkers.values());
    }

    @Override
    public Set<CircleMarker> getCircleMarkers() {
        return new HashSet<CircleMarker>(this.circlemarkers.values());
    }

    @Override
    public Marker createMarker(String id, String label, String world, double x, double y, double z, MarkerIcon icon, boolean is_persistent) {
        return this.createMarker(id, label, false, world, x, y, z, icon, is_persistent);
    }

    @Override
    public Marker createMarker(String id, String label, boolean markup, String world, double x, double y, double z, MarkerIcon icon, boolean is_persistent) {
        if (id == null) {
            int i = 0;
            while (this.markers.containsKey(id = "marker_" + ++i)) {
            }
        }
        if (icon == null) {
            icon = this.deficon;
        }
        if (this.markers.containsKey(id)) {
            return null;
        }
        if (!(icon instanceof MarkerIconImpl)) {
            return null;
        }
        if (this.allowedicons != null && !this.allowedicons.containsKey(icon.getMarkerIconID())) {
            return null;
        }
        is_persistent = is_persistent && this.ispersistent;
        MarkerImpl marker = new MarkerImpl(id, label, markup, world, x, y, z, (MarkerIconImpl)icon, is_persistent, this);
        this.markers.put(id, marker);
        if (is_persistent) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.markerUpdated(marker, MarkerAPIImpl.MarkerUpdate.CREATED);
        return marker;
    }

    @Override
    public Marker findMarker(String id) {
        return this.markers.get(id);
    }

    @Override
    public Marker findMarkerByLabel(String lbl) {
        Marker match = null;
        int matchlen = Integer.MAX_VALUE;
        for (Marker marker : this.markers.values()) {
            if (!marker.getLabel().contains(lbl) || matchlen <= marker.getLabel().length()) continue;
            match = marker;
            matchlen = marker.getLabel().length();
        }
        return match;
    }

    @Override
    public String getMarkerSetID() {
        return this.setid;
    }

    @Override
    public String getMarkerSetLabel() {
        return this.label;
    }

    @Override
    public void setMarkerSetLabel(String lbl) {
        this.label = lbl;
        MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public boolean isMarkerSetPersistent() {
        return this.ispersistent;
    }

    @Override
    public Set<MarkerIcon> getAllowedMarkerIcons() {
        if (this.allowedicons != null) {
            return new HashSet<MarkerIcon>(this.allowedicons.values());
        }
        return null;
    }

    @Override
    public void addAllowedMarkerIcon(MarkerIcon icon) {
        if (!(icon instanceof MarkerIconImpl)) {
            return;
        }
        if (this.allowedicons == null) {
            return;
        }
        this.allowedicons.put(icon.getMarkerIconID(), (MarkerIconImpl)icon);
        MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public void removeAllowedMarkerIcon(MarkerIcon icon) {
        if (!(icon instanceof MarkerIconImpl)) {
            return;
        }
        if (this.allowedicons == null) {
            return;
        }
        this.allowedicons.remove(icon.getMarkerIconID());
        MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public boolean isAllowedMarkerIcon(MarkerIcon icon) {
        if (this.allowedicons == null) {
            return true;
        }
        return this.allowedicons.containsKey(icon.getMarkerIconID());
    }

    @Override
    public Set<MarkerIcon> getMarkerIconsInUse() {
        HashSet<String> ids = new HashSet<String>();
        HashSet<MarkerIcon> icons = new HashSet<MarkerIcon>();
        for (Marker marker : this.markers.values()) {
            MarkerIcon mi = marker.getMarkerIcon();
            if (ids.contains(mi.getMarkerIconID())) continue;
            ids.add(mi.getMarkerIconID());
            icons.add(mi);
        }
        return icons;
    }

    @Override
    public void deleteMarkerSet() {
        MarkerAPIImpl.removeMarkerSet(this);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
        this.cleanup();
    }

    void insertMarker(MarkerImpl marker) {
        this.markers.put(marker.getMarkerID(), marker);
        if (this.ispersistent && marker.isPersistentMarker()) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.markerUpdated(marker, MarkerAPIImpl.MarkerUpdate.CREATED);
    }

    void removeMarker(MarkerImpl marker) {
        this.markers.remove(marker.getMarkerID());
        if (this.ispersistent && marker.isPersistentMarker()) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.markerUpdated(marker, MarkerAPIImpl.MarkerUpdate.DELETED);
    }

    void insertAreaMarker(AreaMarkerImpl marker) {
        this.areamarkers.put(marker.getMarkerID(), marker);
        if (marker.getBoostFlag()) {
            if (this.boostingareamarkers == null) {
                this.boostingareamarkers = new ConcurrentHashMap();
            }
            this.boostingareamarkers.put(marker.getMarkerID(), marker);
        }
        if (marker.getGreetingText() != null || marker.getFarewellText() != null) {
            if (this.enterexitmarkers == null) {
                this.enterexitmarkers = new ConcurrentHashMap();
            }
            this.enterexitmarkers.put(marker.getUniqueMarkerID(), marker);
        }
        if (this.ispersistent && marker.isPersistentMarker()) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.areaMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.CREATED);
    }

    void removeAreaMarker(AreaMarkerImpl marker) {
        this.areamarkers.remove(marker.getMarkerID());
        if (this.boostingareamarkers != null) {
            this.boostingareamarkers.remove(marker.getMarkerID());
            if (this.boostingareamarkers.isEmpty()) {
                this.boostingareamarkers = null;
            }
        }
        if (this.enterexitmarkers != null) {
            this.enterexitmarkers.remove(marker.getUniqueMarkerID());
            if (this.enterexitmarkers.isEmpty()) {
                this.enterexitmarkers = null;
            }
        }
        if (this.ispersistent && marker.isPersistentMarker()) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.areaMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.DELETED);
    }

    void insertPolyLineMarker(PolyLineMarkerImpl marker) {
        this.linemarkers.put(marker.getMarkerID(), marker);
        if (this.ispersistent && marker.isPersistentMarker()) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.polyLineMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.CREATED);
    }

    void removePolyLineMarker(PolyLineMarkerImpl marker) {
        this.linemarkers.remove(marker.getMarkerID());
        if (this.ispersistent && marker.isPersistentMarker()) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.polyLineMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.DELETED);
    }

    void insertCircleMarker(CircleMarkerImpl marker) {
        this.circlemarkers.put(marker.getMarkerID(), marker);
        if (marker.getBoostFlag()) {
            if (this.boostingcirclemarkers == null) {
                this.boostingcirclemarkers = new ConcurrentHashMap();
            }
            this.boostingcirclemarkers.put(marker.getMarkerID(), marker);
        }
        if (marker.getGreetingText() != null || marker.getFarewellText() != null) {
            if (this.enterexitmarkers == null) {
                this.enterexitmarkers = new ConcurrentHashMap();
            }
            this.enterexitmarkers.put(marker.getUniqueMarkerID(), marker);
        }
        if (this.ispersistent && marker.isPersistentMarker()) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.circleMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.CREATED);
    }

    void removeCircleMarker(CircleMarkerImpl marker) {
        this.circlemarkers.remove(marker.getMarkerID());
        if (this.boostingcirclemarkers != null) {
            this.boostingcirclemarkers.remove(marker.getMarkerID());
            if (this.boostingcirclemarkers.isEmpty()) {
                this.boostingcirclemarkers = null;
            }
        }
        if (this.enterexitmarkers != null) {
            this.enterexitmarkers.remove(marker.getUniqueMarkerID());
            if (this.enterexitmarkers.isEmpty()) {
                this.enterexitmarkers = null;
            }
        }
        if (this.ispersistent && marker.isPersistentMarker()) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.circleMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.DELETED);
    }

    Map<String, Object> getPersistentData() {
        if (!this.ispersistent) {
            return null;
        }
        HashMap<Object, Map<String, Object>> node = new HashMap<Object, Map<String, Object>>();
        for (Object id : this.markers.keySet()) {
            MarkerImpl m = this.markers.get(id);
            if (!m.isPersistentMarker()) continue;
            node.put(id, m.getPersistentData());
        }
        HashMap<Object, Map<String, Object>> anode = new HashMap<Object, Map<String, Object>>();
        for (Object id : this.areamarkers.keySet()) {
            AreaMarkerImpl m = this.areamarkers.get(id);
            if (!m.isPersistentMarker()) continue;
            anode.put(id, m.getPersistentData());
        }
        HashMap<Object, Map<String, Object>> lnode = new HashMap<Object, Map<String, Object>>();
        for (Object id : this.linemarkers.keySet()) {
            PolyLineMarkerImpl m = this.linemarkers.get(id);
            if (!m.isPersistentMarker()) continue;
            lnode.put(id, m.getPersistentData());
        }
        HashMap<String, Map<String, Object>> cnode = new HashMap<String, Map<String, Object>>();
        for (String id : this.circlemarkers.keySet()) {
            CircleMarkerImpl m = this.circlemarkers.get(id);
            if (!m.isPersistentMarker()) continue;
            cnode.put(id, m.getPersistentData());
        }
        HashMap<String, Object> setnode = new HashMap<String, Object>();
        setnode.put("label", this.label);
        if (this.allowedicons != null) {
            ArrayList allowed = new ArrayList(this.allowedicons.keySet());
            setnode.put("allowedicons", allowed);
        }
        setnode.put("markers", node);
        setnode.put("areas", anode);
        setnode.put("lines", lnode);
        setnode.put("circles", cnode);
        setnode.put("hide", this.hide_by_def);
        setnode.put("layerprio", this.prio);
        if (this.minzoom >= 0) {
            setnode.put("minzoom", this.minzoom);
        }
        if (this.maxzoom >= 0) {
            setnode.put("maxzoom", this.maxzoom);
        }
        if (this.deficon != null) {
            setnode.put("deficon", this.deficon.getMarkerIconID());
        } else {
            setnode.put("deficon", "default");
        }
        if (this.showlabels != null) {
            setnode.put("showlabels", this.showlabels);
        }
        return setnode;
    }

    boolean loadPersistentData(ConfigurationNode node) {
        List list;
        ConfigurationNode configurationNode;
        ConfigurationNode configurationNode2;
        ConfigurationNode areamarkernode;
        this.label = node.getString("label", this.setid);
        ConfigurationNode markernode = node.getNode("markers");
        if (markernode != null) {
            for (String string : markernode.keySet()) {
                MarkerImpl markerImpl = new MarkerImpl(string, this);
                if (markerImpl.loadPersistentData(markernode.getNode(string))) {
                    this.markers.put(string, markerImpl);
                    continue;
                }
                Log.info("Error loading marker '" + string + "' for set '" + this.setid + "'");
                markerImpl.cleanup();
            }
        }
        if ((areamarkernode = node.getNode("areas")) != null) {
            for (String string : areamarkernode.keySet()) {
                AreaMarkerImpl areaMarkerImpl = new AreaMarkerImpl(string, this);
                if (areaMarkerImpl.loadPersistentData(areamarkernode.getNode(string))) {
                    this.areamarkers.put(string, areaMarkerImpl);
                    if (areaMarkerImpl.getBoostFlag()) {
                        if (this.boostingareamarkers == null) {
                            this.boostingareamarkers = new ConcurrentHashMap();
                        }
                        this.boostingareamarkers.put(string, areaMarkerImpl);
                    }
                    if (areaMarkerImpl.getGreetingText() == null && areaMarkerImpl.getFarewellText() == null) continue;
                    if (this.enterexitmarkers == null) {
                        this.enterexitmarkers = new ConcurrentHashMap();
                    }
                    this.enterexitmarkers.put(areaMarkerImpl.getUniqueMarkerID(), areaMarkerImpl);
                    continue;
                }
                Log.info("Error loading area marker '" + string + "' for set '" + this.setid + "'");
                areaMarkerImpl.cleanup();
            }
        }
        if ((configurationNode2 = node.getNode("lines")) != null) {
            for (String string : configurationNode2.keySet()) {
                PolyLineMarkerImpl polyLineMarkerImpl = new PolyLineMarkerImpl(string, this);
                if (polyLineMarkerImpl.loadPersistentData(configurationNode2.getNode(string))) {
                    this.linemarkers.put(string, polyLineMarkerImpl);
                    continue;
                }
                Log.info("Error loading line marker '" + string + "' for set '" + this.setid + "'");
                polyLineMarkerImpl.cleanup();
            }
        }
        if ((configurationNode = node.getNode("circles")) != null) {
            for (String string : configurationNode.keySet()) {
                CircleMarkerImpl marker = new CircleMarkerImpl(string, this);
                if (marker.loadPersistentData(configurationNode.getNode(string))) {
                    this.circlemarkers.put(string, marker);
                    if (marker.getBoostFlag()) {
                        if (this.boostingcirclemarkers == null) {
                            this.boostingcirclemarkers = new ConcurrentHashMap();
                        }
                        this.boostingcirclemarkers.put(string, marker);
                    }
                    if (marker.getGreetingText() == null && marker.getFarewellText() == null) continue;
                    if (this.enterexitmarkers == null) {
                        this.enterexitmarkers = new ConcurrentHashMap();
                    }
                    this.enterexitmarkers.put(marker.getUniqueMarkerID(), marker);
                    continue;
                }
                Log.info("Error loading circle marker '" + string + "' for set '" + this.setid + "'");
                marker.cleanup();
            }
        }
        if ((list = node.getList("allowedicons")) != null) {
            for (String id : list) {
                MarkerIconImpl icon = MarkerAPIImpl.getMarkerIconImpl(id);
                if (icon != null) {
                    this.allowedicons.put(id, icon);
                    continue;
                }
                Log.info("Error loading allowed icon '" + id + "' for set '" + this.setid + "'");
            }
        }
        this.hide_by_def = node.getBoolean("hide", false);
        this.prio = node.getInteger("layerprio", 0);
        this.minzoom = node.getInteger("minzoom", -1);
        this.maxzoom = node.getInteger("maxzoom", -1);
        if (this.minzoom == 0) {
            this.minzoom = -1;
        }
        this.showlabels = node.containsKey("showlabels") ? Boolean.valueOf(node.getBoolean("showlabels", false)) : null;
        String string = node.getString("deficon");
        this.deficon = string != null && MarkerAPIImpl.api != null ? MarkerAPIImpl.getMarkerIconImpl(string) : MarkerAPIImpl.getMarkerIconImpl("default");
        this.ispersistent = true;
        return true;
    }

    @Override
    public void setHideByDefault(boolean hide) {
        if (this.hide_by_def != hide) {
            this.hide_by_def = hide;
            MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public boolean getHideByDefault() {
        return this.hide_by_def;
    }

    @Override
    public void setLayerPriority(int prio) {
        if (this.prio != prio) {
            this.prio = prio;
            MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public int getLayerPriority() {
        return this.prio;
    }

    @Override
    public AreaMarker createAreaMarker(String id, String lbl, boolean markup, String world, double[] x, double[] z, boolean persistent) {
        if (id == null) {
            int i = 0;
            while (this.areamarkers.containsKey(id = "area_" + ++i)) {
            }
        }
        if (this.areamarkers.containsKey(id)) {
            return null;
        }
        persistent = persistent && this.ispersistent;
        AreaMarkerImpl marker = new AreaMarkerImpl(id, lbl, markup, world, x, z, persistent, this);
        this.areamarkers.put(id, marker);
        if (persistent) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.areaMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.CREATED);
        return marker;
    }

    @Override
    public AreaMarker findAreaMarker(String id) {
        return this.areamarkers.get(id);
    }

    @Override
    public AreaMarker findAreaMarkerByLabel(String lbl) {
        AreaMarker match = null;
        int matchlen = Integer.MAX_VALUE;
        for (AreaMarker areaMarker : this.areamarkers.values()) {
            if (!areaMarker.getLabel().contains(lbl) || matchlen <= areaMarker.getLabel().length()) continue;
            match = areaMarker;
            matchlen = areaMarker.getLabel().length();
        }
        return match;
    }

    @Override
    public PolyLineMarker createPolyLineMarker(String id, String lbl, boolean markup, String world, double[] x, double[] y, double[] z, boolean persistent) {
        if (id == null) {
            int i = 0;
            while (this.linemarkers.containsKey(id = "line_" + ++i)) {
            }
        }
        if (this.linemarkers.containsKey(id)) {
            return null;
        }
        persistent = persistent && this.ispersistent;
        PolyLineMarkerImpl marker = new PolyLineMarkerImpl(id, lbl, markup, world, x, y, z, persistent, this);
        this.linemarkers.put(id, marker);
        if (persistent) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.polyLineMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.CREATED);
        return marker;
    }

    @Override
    public PolyLineMarker findPolyLineMarker(String id) {
        return this.linemarkers.get(id);
    }

    @Override
    public PolyLineMarker findPolyLineMarkerByLabel(String lbl) {
        PolyLineMarker match = null;
        int matchlen = Integer.MAX_VALUE;
        for (PolyLineMarker polyLineMarker : this.linemarkers.values()) {
            if (!polyLineMarker.getLabel().contains(lbl) || matchlen <= polyLineMarker.getLabel().length()) continue;
            match = polyLineMarker;
            matchlen = polyLineMarker.getLabel().length();
        }
        return match;
    }

    @Override
    public void setMinZoom(int minzoom) {
        if (minzoom < 0) {
            minzoom = -1;
        }
        if (this.minzoom != minzoom) {
            this.minzoom = minzoom;
            MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public int getMinZoom() {
        return this.minzoom;
    }

    @Override
    public void setMaxZoom(int maxzoom) {
        if (maxzoom < 0) {
            maxzoom = -1;
        }
        if (this.maxzoom != maxzoom) {
            this.maxzoom = maxzoom;
            MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public int getMaxZoom() {
        return this.maxzoom;
    }

    @Override
    public void setLabelShow(Boolean show) {
        if (show == this.showlabels) {
            return;
        }
        if (show == null || !show.equals(this.showlabels)) {
            this.showlabels = show;
            MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public Boolean getLabelShow() {
        return this.showlabels;
    }

    @Override
    public CircleMarker createCircleMarker(String id, String lbl, boolean markup, String world, double x, double y, double z, double xr, double zr, boolean persistent) {
        if (id == null) {
            int i = 0;
            while (this.circlemarkers.containsKey(id = "circle_" + ++i)) {
            }
        }
        if (this.circlemarkers.containsKey(id)) {
            return null;
        }
        persistent = persistent && this.ispersistent;
        CircleMarkerImpl marker = new CircleMarkerImpl(id, lbl, markup, world, x, y, z, xr, zr, persistent, this);
        this.circlemarkers.put(id, marker);
        if (persistent) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.circleMarkerUpdated(marker, MarkerAPIImpl.MarkerUpdate.CREATED);
        return marker;
    }

    @Override
    public CircleMarker findCircleMarker(String id) {
        return this.circlemarkers.get(id);
    }

    @Override
    public CircleMarker findCircleMarkerByLabel(String lbl) {
        CircleMarker match = null;
        int matchlen = Integer.MAX_VALUE;
        for (CircleMarker circleMarker : this.circlemarkers.values()) {
            if (!circleMarker.getLabel().contains(lbl) || matchlen <= circleMarker.getLabel().length()) continue;
            match = circleMarker;
            matchlen = circleMarker.getLabel().length();
        }
        return match;
    }

    @Override
    public void setDefaultMarkerIcon(MarkerIcon defmark) {
        if (this.deficon != defmark) {
            this.deficon = defmark;
            MarkerAPIImpl.markerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public MarkerIcon getDefaultMarkerIcon() {
        return this.deficon;
    }

    final boolean testTileForBoostMarkers(DynmapWorld w, HDPerspective perspective, double tile_x, double tile_y, double tile_dim) {
        if (this.boostingareamarkers != null) {
            for (AreaMarkerImpl am : this.boostingareamarkers.values()) {
                if (!am.testTileForBoostMarkers(w, perspective, tile_x, tile_y, tile_dim)) continue;
                return true;
            }
        }
        if (this.boostingcirclemarkers != null) {
            for (CircleMarkerImpl cm : this.boostingcirclemarkers.values()) {
                if (!cm.testTileForBoostMarkers(w, perspective, tile_x, tile_y, tile_dim)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addEnteredMarkers(Set<EnterExitMarker> entered, String worldid, double x, double y, double z) {
        if (this.enterexitmarkers == null) {
            return;
        }
        for (EnterExitMarker m : this.enterexitmarkers.values()) {
            if (!m.testIfPointWithinMarker(worldid, x, y, z)) continue;
            entered.add(m);
        }
    }
}

